/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.Serializable;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Metadata;
import org.dspace.app.xmlui.wing.element.PageMeta;

public class SystemwideAlerts
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Message T_COUNTDOWN = SystemwideAlerts.message((String)"xmlui.administrative.SystemwideAlerts.countdown");
    public static final int STATE_ALL_SESSIONS = 1;
    public static final int STATE_CURRENT_SESSIONS = 2;
    public static final int STATE_ONLY_ADMINISTRATIVE_SESSIONS = 3;
    private static boolean active;
    private static String message;
    private static long countDownToo;
    private static int restrictsessions;

    public Serializable getKey() {
        if (active) {
            return null;
        }
        return "1";
    }

    public SourceValidity getValidity() {
        if (active) {
            return null;
        }
        return NOPValidity.SHARED_INSTANCE;
    }

    public void addPageMeta(PageMeta pageMeta) throws WingException {
        if (active) {
            Metadata alert = pageMeta.addMetadata("alert", "message");
            long time = countDownToo - System.currentTimeMillis();
            if (time > 0L) {
                alert.addContent(T_COUNTDOWN.parameterize(new Object[]{time /= 60000L}));
            }
            alert.addContent(message);
        }
    }

    public static boolean isAlertActive() {
        return active;
    }

    public static void activateAlert() {
        active = true;
    }

    public static void deactivateAlert() {
        active = false;
    }

    public static void setMessage(String message) {
        SystemwideAlerts.message = message;
    }

    public static String getMessage() {
        return message;
    }

    public static long getCountDownToo() {
        return countDownToo;
    }

    public static void setCountDownToo(long countDownTo) {
        countDownToo = countDownTo;
    }

    public static int getRestrictSessions() {
        return restrictsessions;
    }

    public static void setRestrictSessions(int restrictsessions) {
        if (restrictsessions == 1 || restrictsessions == 2 || restrictsessions == 3) {
            SystemwideAlerts.restrictsessions = restrictsessions;
        }
    }

    public static boolean canUserStartSession() {
        return !active || restrictsessions != 3 && restrictsessions != 2;
    }

    public static boolean canUserMaintainSession() {
        return !active || restrictsessions != 3;
    }

    static {
        restrictsessions = 1;
    }
}

