/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission.submit;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.app.xmlui.aspect.submission.AbstractStep;
import org.dspace.app.xmlui.aspect.submission.AbstractSubmissionStep;
import org.dspace.app.xmlui.aspect.submission.FlowUtils;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.submit.step.UploadStep;
import org.xml.sax.SAXException;

public class ReviewStep
extends AbstractSubmissionStep {
    protected static final Message T_head = ReviewStep.message((String)"xmlui.Submission.submit.ReviewStep.head");
    protected static final Message T_yes = ReviewStep.message((String)"xmlui.Submission.submit.ReviewStep.yes");
    protected static final Message T_no = ReviewStep.message((String)"xmlui.Submission.submit.ReviewStep.no");
    protected static final Message T_submit_jump = ReviewStep.message((String)"xmlui.Submission.submit.ReviewStep.submit_jump");
    protected static final Message T_no_metadata = ReviewStep.message((String)"xmlui.Submission.submit.ReviewStep.no_metadata");
    protected static final Message T_unknown = ReviewStep.message((String)"xmlui.Submission.submit.ReviewStep.unknown");
    protected static final Message T_known = ReviewStep.message((String)"xmlui.Submission.submit.ReviewStep.known");
    protected static final Message T_supported = ReviewStep.message((String)"xmlui.Submission.submit.ReviewStep.supported");
    private SourceResolver resolver;
    private String src;
    private static Logger log = Logger.getLogger(UploadStep.class);

    public ReviewStep() {
        this.requireSubmission = true;
        this.requireStep = true;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        this.resolver = resolver;
        this.src = src;
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        double currentStepAndPage;
        Collection collection = this.submission.getCollection();
        String actionURL = this.contextPath + "/handle/" + collection.getHandle() + "/submit/" + this.knot.getId() + ".continue";
        SubmissionConfig subConfig = this.submissionInfo.getSubmissionConfig();
        Division div = body.addInteractiveDivision("submit-upload", actionURL, "post", "primary submission");
        div.setHead(T_submission_head);
        this.addSubmissionProgressList(div);
        List review = div.addList("submit-review", "form");
        review.setHead(T_head);
        Set submissionPagesSet = this.submissionInfo.getProgressBarInfo().keySet();
        String[] submissionPages = submissionPagesSet.toArray(new String[submissionPagesSet.size()]);
        for (int i = 0; i < submissionPages.length && (currentStepAndPage = Double.valueOf(submissionPages[i]).doubleValue()) != this.stepAndPage; ++i) {
            SubmissionStepConfig stepConfig = subConfig.getStep(FlowUtils.getStep(currentStepAndPage));
            AbstractStep stepUIClass = this.loadXMLUIClass(stepConfig.getXMLUIClassName());
            try {
                this.parameters.setParameter("step", Double.toString(currentStepAndPage));
                stepUIClass.setup(this.resolver, this.objectModel, this.src, this.parameters);
            }
            catch (Exception e) {
                throw new UIException("Unable to initialize AbstractStep identified by " + stepConfig.getXMLUIClassName() + ":", e);
            }
            if (stepUIClass instanceof AbstractSubmissionStep) {
                List stepSection = ((AbstractSubmissionStep)stepUIClass).addReviewSection(review);
                if (stepSection == null) continue;
                this.addJumpButton(stepSection, T_submit_jump, currentStepAndPage);
                continue;
            }
            log.warn((Object)("The Step represented by " + stepConfig.getXMLUIClassName() + " is not a valid AbstractSubmissionStep, so it cannot be reviewed during the ReviewStep!"));
        }
        this.addControlButtons(review);
    }

    public List addReviewSection(List reviewList) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        return null;
    }

    public void recycle() {
        super.recycle();
    }

    private AbstractStep loadXMLUIClass(String transformerClassName) throws UIException {
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            Class<?> stepClass = loader.loadClass(transformerClassName);
            return (AbstractStep)stepClass.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new UIException("Class Not Found: " + transformerClassName, cnfe);
        }
        catch (Exception e) {
            throw new UIException("Unable to instantiate class " + transformerClassName + ". " + "Please make sure it extends org.dspace.app.xmlui.submission.AbstractSubmissionStep!", e);
        }
    }
}

