/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.servlet.multipart.Part;
import org.dspace.app.xmlui.aspect.administrative.FlowResult;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.FormatIdentifier;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;

public class FlowItemUtils {
    private static final Message T_metadata_updated = new Message("default", "The Item's metadata was successfully updated.");
    private static final Message T_metadata_added = new Message("default", "New metadata was added.");
    private static final Message T_item_withdrawn = new Message("default", "The item has been withdrawn.");
    private static final Message T_item_reinstated = new Message("default", "The item has been reinstated.");
    private static final Message T_bitstream_added = new Message("default", "The new bitstream was successfully uploaded.");
    private static final Message T_bitstream_failed = new Message("default", "Error while uploading file.");
    private static final Message T_bitstream_updated = new Message("default", "The bitstream has been updated.");
    private static final Message T_bitstream_delete = new Message("default", "The selected bitstreams have been deleted.");

    public static FlowResult resolveItemIdentifier(Context context, String identifier) throws SQLException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        if (identifier.contains("/")) {
            DSpaceObject dso = HandleManager.resolveToObject((Context)context, (String)identifier);
            if (dso != null && dso.getType() == 2) {
                result.setParameter("itemID", dso.getID());
                result.setParameter("type", 2);
                result.setContinue(true);
                return result;
            }
        } else {
            Item item = null;
            try {
                item = Item.find((Context)context, (int)Integer.valueOf(identifier));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (item != null) {
                result.setParameter("itemID", item.getID());
                result.setParameter("type", 2);
                result.setContinue(true);
                return result;
            }
        }
        result.addError("identifier");
        return result;
    }

    public static FlowResult processEditItem(Context context, int itemID, Request request) throws SQLException, AuthorizeException, UIException, IOException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Item item = Item.find((Context)context, (int)itemID);
        String scope = request.getParameter("scope");
        if ("*".equals(scope)) {
            item.clearMetadata("*", "*", "*", "*");
        } else {
            String[] parts = FlowItemUtils.parseName(scope);
            item.clearMetadata(parts[0], parts[1], parts[2], "*");
        }
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        Enumeration parameters = request.getParameterNames();
        while (parameters.hasMoreElements()) {
            String parameterName = (String)parameters.nextElement();
            if (!parameterName.startsWith("name_")) continue;
            String parameterValue = request.getParameter(parameterName);
            if (!"*".equals(scope) && !scope.equals(parameterValue)) continue;
            String indexString = parameterName.substring("name_".length());
            Integer index = Integer.valueOf(indexString);
            indexes.add(index);
        }
        Integer index = 1;
        while (index <= indexes.size()) {
            String name = request.getParameter("name_" + index);
            String value = request.getParameter("value_" + index);
            String lang = request.getParameter("language_" + index);
            String remove = request.getParameter("remove_" + index);
            if (remove == null) {
                String[] parts = FlowItemUtils.parseName(name);
                item.addMetadata(parts[0], parts[1], parts[2], lang, value);
            }
            index = index + 1;
        }
        item.update();
        context.commit();
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(T_metadata_updated);
        return result;
    }

    public static FlowResult processAddMetadata(Context context, int itemID, Request request) throws SQLException, AuthorizeException, UIException, IOException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Item item = Item.find((Context)context, (int)itemID);
        String fieldID = request.getParameter("field");
        String value = request.getParameter("value");
        String language = request.getParameter("language");
        MetadataField field = MetadataField.find((Context)context, (int)Integer.valueOf(fieldID));
        MetadataSchema schema = MetadataSchema.find((Context)context, (int)field.getSchemaID());
        item.addMetadata(schema.getName(), field.getElement(), field.getQualifier(), language, value);
        item.update();
        context.commit();
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(T_metadata_added);
        return result;
    }

    public static FlowResult processWithdrawItem(Context context, int itemID) throws SQLException, AuthorizeException, IOException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Item item = Item.find((Context)context, (int)itemID);
        item.withdraw();
        context.commit();
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(T_item_withdrawn);
        return result;
    }

    public static FlowResult processReinstateItem(Context context, int itemID) throws SQLException, AuthorizeException, IOException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Item item = Item.find((Context)context, (int)itemID);
        item.reinstate();
        context.commit();
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(T_item_reinstated);
        return result;
    }

    public static FlowResult processDeleteItem(Context context, int itemID) throws SQLException, AuthorizeException, IOException {
        Collection[] collections;
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Item item = Item.find((Context)context, (int)itemID);
        for (Collection collection : collections = item.getCollections()) {
            collection.removeItem(item);
        }
        context.commit();
        result.setContinue(true);
        return result;
    }

    public static FlowResult processAddBitstream(Context context, int itemID, Request request) throws SQLException, AuthorizeException, IOException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Item item = Item.find((Context)context, (int)itemID);
        Object object = request.get("file");
        Part filePart = null;
        if (object instanceof Part) {
            filePart = (Part)object;
        }
        if (filePart != null && filePart.getSize() > 0) {
            Bitstream bitstream;
            InputStream is = filePart.getInputStream();
            String bundleName = request.getParameter("bundle");
            Bundle[] bundles = item.getBundles(bundleName);
            if (bundles.length < 1) {
                bitstream = item.createSingleBitstream(is, bundleName);
                Collection owningCollection = item.getOwningCollection();
                if (owningCollection != null) {
                    Bundle bnd = bitstream.getBundles()[0];
                    bnd.inheritCollectionDefaultPolicies(owningCollection);
                }
            } else {
                bitstream = bundles[0].createBitstream(is);
            }
            String name = filePart.getUploadName();
            while (name.indexOf(47) > -1) {
                name = name.substring(name.indexOf(47) + 1);
            }
            while (name.indexOf(92) > -1) {
                name = name.substring(name.indexOf(92) + 1);
            }
            bitstream.setName(name);
            bitstream.setSource(filePart.getUploadName());
            bitstream.setDescription(request.getParameter("description"));
            BitstreamFormat format = FormatIdentifier.guessFormat((Context)context, (Bitstream)bitstream);
            bitstream.setFormat(format);
            bitstream.update();
            item.update();
            result.setContinue(true);
            result.setOutcome(true);
            result.setMessage(T_bitstream_added);
        } else {
            result.setContinue(false);
            result.setOutcome(false);
            result.setMessage(T_bitstream_failed);
        }
        return result;
    }

    public static FlowResult processEditBitstream(Context context, int itemID, int bitstreamID, String primary, String description, int formatID, String userFormat) throws SQLException, AuthorizeException {
        Bundle[] bundles;
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Bitstream bitstream = Bitstream.find((Context)context, (int)bitstreamID);
        BitstreamFormat currentFormat = bitstream.getFormat();
        if (description != null && description.length() > 0) {
            bitstream.setDescription(description);
        }
        if ((bundles = bitstream.getBundles()) != null && bundles.length > 0) {
            if (bitstreamID == bundles[0].getPrimaryBitstreamID()) {
                if ("no".equals(primary)) {
                    bundles[0].unsetPrimaryBitstreamID();
                    bundles[0].update();
                }
            } else if ("yes".equals(primary)) {
                bundles[0].setPrimaryBitstreamID(bitstreamID);
                bundles[0].update();
            }
        }
        if (formatID > 0) {
            BitstreamFormat newFormat;
            if ((currentFormat == null || currentFormat.getID() != formatID) && (newFormat = BitstreamFormat.find((Context)context, (int)formatID)) != null) {
                bitstream.setFormat(newFormat);
            }
        } else if (userFormat != null && userFormat.length() > 0) {
            bitstream.setUserFormatDescription(userFormat);
        }
        bitstream.update();
        context.commit();
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(T_bitstream_updated);
        return result;
    }

    public static FlowResult processDeleteBitstreams(Context context, int itemID, String[] bitstreamIDs) throws SQLException, AuthorizeException, IOException, UIException {
        FlowResult result = new FlowResult();
        result.setContinue(false);
        Item item = Item.find((Context)context, (int)itemID);
        for (String id : bitstreamIDs) {
            String[] parts = id.split("/");
            if (parts.length != 2) {
                throw new UIException("Unable to parse id into bundle and bitstream id: " + id);
            }
            int bundleID = Integer.valueOf(parts[0]);
            int bitstreamID = Integer.valueOf(parts[1]);
            Bundle bundle = Bundle.find((Context)context, (int)bundleID);
            Bitstream bitstream = Bitstream.find((Context)context, (int)bitstreamID);
            bundle.removeBitstream(bitstream);
            if (bundle.getBitstreams().length != 0) continue;
            item.removeBundle(bundle);
        }
        item.update();
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(T_bitstream_delete);
        return result;
    }

    private static String[] parseName(String name) throws UIException {
        String[] parts = new String[3];
        String[] split = name.split("_");
        if (split.length == 2) {
            parts[0] = split[0];
            parts[1] = split[1];
            parts[2] = null;
        } else if (split.length == 3) {
            parts[0] = split[0];
            parts[1] = split[1];
            parts[2] = split[2];
        } else {
            throw new UIException("Unable to parse metedata field name: " + name);
        }
        return parts;
    }
}

