/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.sword2.AbstractSimpleDC;
import org.dspace.sword2.DSpaceSwordException;
import org.dspace.sword2.DepositResult;
import org.dspace.sword2.SwordEntryIngester;
import org.dspace.sword2.VerboseDescription;
import org.swordapp.server.Deposit;
import org.swordapp.server.SwordAuthException;
import org.swordapp.server.SwordEntry;
import org.swordapp.server.SwordError;
import org.swordapp.server.SwordServerException;

public class SimpleDCEntryIngester
extends AbstractSimpleDC
implements SwordEntryIngester {
    private static final Logger log = LogManager.getLogger(SimpleDCEntryIngester.class);
    protected WorkspaceItemService workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    public SimpleDCEntryIngester() {
        this.loadMetadataMaps();
    }

    @Override
    public DepositResult ingest(Context context, Deposit deposit, DSpaceObject dso, VerboseDescription verboseDescription) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        return this.ingest(context, deposit, dso, verboseDescription, null, false);
    }

    @Override
    public DepositResult ingest(Context context, Deposit deposit, DSpaceObject dso, VerboseDescription verboseDescription, DepositResult result, boolean replace) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        if (dso instanceof Collection) {
            return this.ingestToCollection(context, deposit, (Collection)dso, verboseDescription, result);
        }
        if (dso instanceof Item) {
            return this.ingestToItem(context, deposit, (Item)dso, verboseDescription, result, replace);
        }
        return null;
    }

    public DepositResult ingestToItem(Context context, Deposit deposit, Item item, VerboseDescription verboseDescription, DepositResult result, boolean replace) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        try {
            if (result == null) {
                result = new DepositResult();
            }
            result.setItem(item);
            if (replace) {
                this.removeMetadata(context, item);
            }
            this.addMetadataToItem(context, deposit, item);
            this.setUpdatedDate(context, item, verboseDescription);
            context.turnOffAuthorisationSystem();
            this.itemService.update(context, (DSpaceObject)item);
            context.restoreAuthSystemState();
            verboseDescription.append("Update successful");
            result.setItem(item);
            result.setTreatment(this.getTreatment());
            return result;
        }
        catch (SQLException | AuthorizeException e) {
            throw new DSpaceSwordException(e);
        }
    }

    private void removeMetadata(Context context, Item item) throws DSpaceSwordException {
        String[] replaceableMetadata;
        for (String part : replaceableMetadata = this.configurationService.getArrayProperty("swordv2-server.metadata.replaceable")) {
            MetadataValueInfo info = this.makeMetadataValueInfo(part.trim(), null);
            try {
                this.itemService.clearMetadata(context, (DSpaceObject)item, info.schema, info.element, info.qualifier, "*");
            }
            catch (SQLException e) {
                log.error("Caught exception trying to remove metadata", (Throwable)e);
                throw new DSpaceSwordException(e);
            }
        }
    }

    private void addUniqueMetadata(Context context, MetadataValueInfo info, Item item) throws SQLException {
        String qual = info.qualifier;
        if (info.qualifier == null) {
            qual = "*";
        }
        String lang = info.language;
        if (info.language == null) {
            lang = "*";
        }
        List existing = this.itemService.getMetadata((DSpaceObject)item, info.schema, info.element, qual, lang);
        for (MetadataValue dcValue : existing) {
            if (!dcValue.getValue().equals(info.value)) continue;
            return;
        }
        this.itemService.addMetadata(context, (DSpaceObject)item, info.schema, info.element, info.qualifier, info.language, info.value);
    }

    private void addMetadataToItem(Context context, Deposit deposit, Item item) throws DSpaceSwordException {
        String abstractField;
        MetadataValueInfo info;
        String titleField;
        SwordEntry se = deposit.getSwordEntry();
        String title = se.getTitle();
        String summary = se.getSummary();
        if (title != null && (titleField = (String)this.dcMap.get("title")) != null) {
            info = this.makeMetadataValueInfo(titleField, title);
            try {
                this.addUniqueMetadata(context, info, item);
            }
            catch (SQLException e) {
                log.error("Caught exception trying to add title", (Throwable)e);
                throw new DSpaceSwordException(e);
            }
        }
        if (summary != null && (abstractField = (String)this.dcMap.get("abstract")) != null) {
            info = this.makeMetadataValueInfo(abstractField, summary);
            try {
                this.addUniqueMetadata(context, info, item);
            }
            catch (SQLException e) {
                log.error("Caught exception trying to set abstract", (Throwable)e);
                throw new DSpaceSwordException(e);
            }
        }
        Map dc = se.getDublinCore();
        for (String term : dc.keySet()) {
            String dsTerm = (String)this.dcMap.get(term);
            if (dsTerm == null) continue;
            MetadataValueInfo info2 = this.makeMetadataValueInfo(dsTerm, null);
            Iterator iterator = ((List)dc.get(term)).iterator();
            while (iterator.hasNext()) {
                String value;
                info2.value = value = (String)iterator.next();
                try {
                    this.addUniqueMetadata(context, info2, item);
                }
                catch (SQLException e) {
                    log.error("Caught exception trying to add metadata", (Throwable)e);
                    throw new DSpaceSwordException(e);
                }
            }
        }
    }

    public DepositResult ingestToCollection(Context context, Deposit deposit, Collection collection, VerboseDescription verboseDescription, DepositResult result) throws DSpaceSwordException, SwordError, SwordAuthException, SwordServerException {
        try {
            Item item = null;
            WorkspaceItem wsi = null;
            if (result != null) {
                item = result.getItem();
            } else {
                result = new DepositResult();
            }
            if (item == null) {
                wsi = this.workspaceItemService.create(context, collection, true);
                item = wsi.getItem();
            }
            this.addMetadataToItem(context, deposit, item);
            this.setUpdatedDate(context, item, verboseDescription);
            this.setSlug(context, item, deposit.getSlug(), verboseDescription);
            context.turnOffAuthorisationSystem();
            this.itemService.update(context, (DSpaceObject)item);
            context.restoreAuthSystemState();
            verboseDescription.append("Ingest successful");
            verboseDescription.append("Item created with internal identifier: " + item.getID());
            result.setItem(item);
            result.setTreatment(this.getTreatment());
            return result;
        }
        catch (AuthorizeException e) {
            throw new SwordAuthException((Throwable)e);
        }
        catch (SQLException e) {
            throw new DSpaceSwordException(e);
        }
    }

    public MetadataValueInfo makeMetadataValueInfo(String field, String value) throws DSpaceSwordException {
        MetadataValueInfo dcv = new MetadataValueInfo();
        String[] bits = field.split("\\.");
        if (bits.length < 2 || bits.length > 3) {
            throw new DSpaceSwordException("invalid DC value: " + field);
        }
        dcv.schema = bits[0];
        dcv.element = bits[1];
        if (bits.length == 3) {
            dcv.qualifier = bits[2];
        }
        dcv.value = value;
        return dcv;
    }

    protected void setUpdatedDate(Context context, Item item, VerboseDescription verboseDescription) throws DSpaceSwordException {
        String field = this.configurationService.getProperty("swordv2-server.updated.field");
        if (StringUtils.isBlank((CharSequence)field)) {
            throw new DSpaceSwordException("No configuration, or configuration is invalid for: swordv2-server.updated.field");
        }
        MetadataValueInfo info = this.makeMetadataValueInfo(field, null);
        try {
            this.itemService.clearMetadata(context, (DSpaceObject)item, info.schema, info.element, info.qualifier, "*");
            DCDate date = new DCDate(new Date());
            this.itemService.addMetadata(context, (DSpaceObject)item, info.schema, info.element, info.qualifier, null, date.toString());
        }
        catch (SQLException e) {
            log.error("Exception caught trying to set updated date", (Throwable)e);
            throw new DSpaceSwordException(e);
        }
        verboseDescription.append("Updated date added to response from item metadata where available");
    }

    protected void setSlug(Context context, Item item, String slugVal, VerboseDescription verboseDescription) throws DSpaceSwordException {
        if (slugVal == null) {
            return;
        }
        String field = this.configurationService.getProperty("swordv2-server.slug.field");
        if (StringUtils.isBlank((CharSequence)field)) {
            throw new DSpaceSwordException("No configuration, or configuration is invalid for: swordv2-server.slug.field");
        }
        MetadataValueInfo info = this.makeMetadataValueInfo(field, null);
        try {
            this.itemService.clearMetadata(context, (DSpaceObject)item, info.schema, info.element, info.qualifier, "*");
            this.itemService.addMetadata(context, (DSpaceObject)item, info.schema, info.element, info.qualifier, null, slugVal);
        }
        catch (SQLException e) {
            log.error("Caught exception trying to set slug", (Throwable)e);
            throw new DSpaceSwordException(e);
        }
        verboseDescription.append("Slug value set in response where available");
    }

    private String getTreatment() throws DSpaceSwordException {
        return "A metadata only item has been created";
    }

    private class MetadataValueInfo {
        private String schema;
        private String element;
        private String qualifier;
        private String language;
        private String value;

        private MetadataValueInfo() {
        }
    }
}

