/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword2;

import java.util.HashMap;
import java.util.List;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.sword2.SimpleDCMetadata;

public class AbstractSimpleDC {
    private static final String DC_PREFIX = "swordv2-server.simpledc";
    private static final String ATOM_PREFIX = "swordv2-server.atom";
    protected HashMap<String, String> dcMap = null;
    protected HashMap<String, String> atomMap = null;
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    protected void loadMetadataMaps() {
        String v;
        String k;
        List keys;
        if (this.dcMap == null) {
            this.dcMap = new HashMap();
            keys = this.configurationService.getPropertyKeys(DC_PREFIX);
            for (String key : keys) {
                k = key.substring(DC_PREFIX.length() + 1);
                v = this.configurationService.getProperty(key);
                this.dcMap.put(k, v);
            }
        }
        if (this.atomMap == null) {
            this.atomMap = new HashMap();
            keys = this.configurationService.getPropertyKeys(ATOM_PREFIX);
            for (String key : keys) {
                k = key.substring(ATOM_PREFIX.length() + 1);
                v = this.configurationService.getProperty(key);
                this.atomMap.put(k, v);
            }
        }
    }

    protected SimpleDCMetadata getMetadata(Item item) {
        this.loadMetadataMaps();
        SimpleDCMetadata md = new SimpleDCMetadata();
        List all = this.itemService.getMetadata((DSpaceObject)item, "*", "*", "*", "*");
        for (MetadataValue dcv : all) {
            String value;
            MetadataField field = dcv.getMetadataField();
            String valueMatch = field.getMetadataSchema().getName() + "." + field.getElement();
            if (field.getQualifier() != null) {
                valueMatch = valueMatch + "." + field.getQualifier();
            }
            for (String key : this.dcMap.keySet()) {
                value = this.dcMap.get(key);
                if (!valueMatch.equals(value)) continue;
                md.addDublinCore(key, dcv.getValue());
            }
            for (String key : this.atomMap.keySet()) {
                value = this.atomMap.get(key);
                if (!valueMatch.equals(value)) continue;
                md.addAtom(key, dcv.getValue());
            }
        }
        return md;
    }
}

