/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.io.File;
import java.sql.SQLException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.packager.PackageIngester;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.DepositResult;
import org.dspace.sword.SWORDIngester;
import org.dspace.sword.SWORDService;
import org.purl.sword.base.Deposit;
import org.purl.sword.base.SWORDErrorException;

public class SWORDMETSIngester
implements SWORDIngester {
    private SWORDService swordService;
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    public static final Logger log = LogManager.getLogger(SWORDMETSIngester.class);

    @Override
    public DepositResult ingest(SWORDService service, Deposit deposit, DSpaceObject dso) throws DSpaceSWORDException, SWORDErrorException {
        try {
            if (!(dso instanceof Collection)) {
                throw new DSpaceSWORDException("Tried to run an ingester on wrong target type");
            }
            Collection collection = (Collection)dso;
            this.swordService = service;
            Context context = this.swordService.getContext();
            File depositFile = deposit.getFile();
            String cfg = this.configurationService.getProperty("sword-server.mets-ingester.package-ingester");
            if (cfg == null || "".equals(cfg)) {
                cfg = "METS";
            }
            this.swordService.message("Using package manifest format: " + cfg);
            PackageIngester pi = (PackageIngester)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(PackageIngester.class, cfg);
            this.swordService.message("Loaded package ingester: " + pi.getClass().getName());
            String licence = null;
            PackageParameters params = new PackageParameters();
            params.setWorkflowEnabled(true);
            if (this.configurationService.getBooleanProperty("sword-server.restore-mode.enable", false)) {
                params.setRestoreModeEnabled(true);
            }
            params.setUseCollectionTemplate(this.configurationService.getBooleanProperty("mets.default.ingest.useCollectionTemplate", false));
            DSpaceObject ingestedObject = pi.ingest(context, (DSpaceObject)collection, depositFile, params, licence);
            if (ingestedObject == null) {
                this.swordService.message("Failed to ingest the package; throwing exception");
                throw new SWORDErrorException("http://www.dspace.org/ns/sword/1.3.1/errors/UnpackageFail", "METS package ingester failed to unpack package");
            }
            if (!(ingestedObject instanceof Item)) {
                throw new DSpaceSWORDException("DSpace Ingester returned wrong object type -- not an Item result.");
            }
            this.swordService.message("Workflow process started");
            Item installedItem = (Item)ingestedObject;
            this.setUpdatedDate(context, installedItem);
            this.setSlug(installedItem, deposit.getSlug());
            context.turnOffAuthorisationSystem();
            this.itemService.update(context, (DSpaceObject)installedItem);
            context.restoreAuthSystemState();
            HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
            String handle = handleService.findHandle(context, (DSpaceObject)installedItem);
            this.swordService.message("Ingest successful");
            this.swordService.message("Item created with internal identifier: " + installedItem.getID());
            if (handle != null) {
                this.swordService.message("Item created with external identifier: " + handle);
            } else {
                this.swordService.message("No external identifier available at this stage (item in workflow)");
            }
            DepositResult dr = new DepositResult();
            dr.setItem(installedItem);
            dr.setHandle(handle);
            dr.setTreatment(this.getTreatment());
            return dr;
        }
        catch (RuntimeException re) {
            log.error("caught exception: ", (Throwable)re);
            throw re;
        }
        catch (Exception e) {
            log.error("caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException(e);
        }
    }

    private void setUpdatedDate(Context context, Item item) throws DSpaceSWORDException {
        String field = this.configurationService.getProperty("sword-server.updated.field");
        if (field == null || "".equals(field)) {
            throw new DSpaceSWORDException("No configuration, or configuration is invalid for: sword.updated.field");
        }
        MetadataFieldInfo dc = this.configToDC(field, null);
        try {
            this.itemService.clearMetadata(context, (DSpaceObject)item, dc.schema, dc.element, dc.qualifier, "*");
            DCDate date = new DCDate(ZonedDateTime.now(ZoneOffset.UTC));
            this.itemService.addMetadata(context, (DSpaceObject)item, dc.schema, dc.element, dc.qualifier, null, date.toString());
        }
        catch (SQLException e) {
            log.error("Caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException(e);
        }
        this.swordService.message("Updated date added to response from item metadata where available");
    }

    private void setSlug(Item item, String slugVal) throws DSpaceSWORDException {
        if (slugVal == null) {
            return;
        }
        String field = this.configurationService.getProperty("sword-server.slug.field");
        if (field == null || "".equals(field)) {
            throw new DSpaceSWORDException("No configuration, or configuration is invalid for: sword.slug.field");
        }
        MetadataFieldInfo mfi = this.configToDC(field, null);
        try {
            this.itemService.clearMetadata(this.swordService.getContext(), (DSpaceObject)item, mfi.schema, mfi.element, mfi.qualifier, "*");
            this.itemService.addMetadata(this.swordService.getContext(), (DSpaceObject)item, mfi.schema, mfi.element, mfi.qualifier, null, slugVal);
        }
        catch (SQLException e) {
            log.error("Caught exception: ", (Throwable)e);
            throw new DSpaceSWORDException(e);
        }
        this.swordService.message("Slug value set in response where available");
    }

    private MetadataFieldInfo configToDC(String config, String def) {
        MetadataFieldInfo mfi = new MetadataFieldInfo();
        mfi.schema = def;
        mfi.element = def;
        mfi.qualifier = def;
        StringTokenizer stz = new StringTokenizer(config, ".");
        mfi.schema = stz.nextToken();
        mfi.element = stz.nextToken();
        if (stz.hasMoreTokens()) {
            mfi.qualifier = stz.nextToken();
        }
        return mfi;
    }

    private String getTreatment() throws DSpaceSWORDException {
        return "The package has been deposited into DSpace.  Each file has been unpacked and provided with a unique identifier.  The metadata in the manifest has been extracted and attached to the DSpace item, which has been provided with an identifier leading to an HTML splash page.";
    }

    private class MetadataFieldInfo {
        private String schema;
        private String element;
        private String qualifier;

        private MetadataFieldInfo() {
        }
    }
}

