/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.core.service.PluginService;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.SWORDIngester;
import org.purl.sword.base.Deposit;
import org.purl.sword.base.SWORDErrorException;

public class SWORDIngesterFactory {
    private SWORDIngesterFactory() {
    }

    public static SWORDIngester getInstance(Context context, Deposit deposit, DSpaceObject dso) throws DSpaceSWORDException, SWORDErrorException {
        PluginService pluginService = CoreServiceFactory.getInstance().getPluginService();
        if (dso instanceof Collection) {
            SWORDIngester ingester = (SWORDIngester)pluginService.getNamedPlugin(SWORDIngester.class, deposit.getPackaging());
            if (ingester == null) {
                throw new SWORDErrorException("http://purl.org/net/sword/error/ErrorContent", "No ingester configured for this package type");
            }
            return ingester;
        }
        if (dso instanceof Item) {
            SWORDIngester ingester = (SWORDIngester)pluginService.getNamedPlugin(SWORDIngester.class, "SimpleFileIngester");
            if (ingester == null) {
                throw new DSpaceSWORDException("SimpleFileIngester is not configured in plugin manager");
            }
            return ingester;
        }
        throw new DSpaceSWORDException("No ingester could be found which works for this DSpace Object");
    }
}

