/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.atom;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import nu.xom.Attribute;
import nu.xom.Element;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.purl.sword.atom.ContentType;
import org.purl.sword.base.SwordElementInterface;
import org.purl.sword.base.SwordValidationInfo;
import org.purl.sword.base.SwordValidationInfoType;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.XmlElement;
import org.purl.sword.base.XmlName;

public class TextConstruct
extends XmlElement
implements SwordElementInterface {
    private String content;
    private ContentType type;
    private static Logger log = LogManager.getLogger(TextConstruct.class);
    public static final String ATTRIBUTE_TYPE = "type";

    public TextConstruct(String prefix, String name) {
        this(prefix, name, "http://www.w3.org/2005/Atom");
    }

    public TextConstruct(String name) {
        this("atom", name);
    }

    public TextConstruct(XmlName name) {
        super(name);
    }

    public TextConstruct(String prefix, String name, String namespaceUri) {
        super(prefix, name, namespaceUri);
        this.initialise();
    }

    protected final void initialise() {
        this.type = ContentType.TEXT;
        this.content = null;
    }

    @Override
    public Element marshall() {
        Element element = new Element(this.getQualifiedName(), "http://www.w3.org/2005/Atom");
        if (this.type != null) {
            Attribute typeAttribute = new Attribute(ATTRIBUTE_TYPE, this.type.toString());
            element.addAttribute(typeAttribute);
        }
        if (this.content != null) {
            element.appendChild(this.content);
        }
        return element;
    }

    @Override
    public void unmarshall(Element text) throws UnmarshallException {
        this.unmarshall(text, null);
    }

    public SwordValidationInfo unmarshall(Element text, Properties validationProperties) throws UnmarshallException {
        if (!this.isInstanceOf(text, this.xmlName)) {
            return this.handleIncorrectElement(text, validationProperties);
        }
        ArrayList<SwordValidationInfo> validationItems = new ArrayList<SwordValidationInfo>();
        ArrayList<SwordValidationInfo> attributeItems = new ArrayList<SwordValidationInfo>();
        try {
            this.initialise();
            int attributeCount = text.getAttributeCount();
            Attribute attribute = null;
            for (int i = 0; i < attributeCount; ++i) {
                attribute = text.getAttribute(i);
                if (ATTRIBUTE_TYPE.equals(attribute.getQualifiedName())) {
                    SwordValidationInfo info;
                    boolean success = true;
                    String value = attribute.getValue();
                    if (ContentType.TEXT.toString().equals(value)) {
                        this.type = ContentType.TEXT;
                    } else if (ContentType.HTML.toString().equals(value)) {
                        this.type = ContentType.HTML;
                    } else if (ContentType.XHTML.toString().equals(value)) {
                        this.type = ContentType.XHTML;
                    } else {
                        log.error("Unable to parse extract type in " + this.getQualifiedName());
                        info = new SwordValidationInfo(this.xmlName, new XmlName(attribute), "Invalid content type has been specified", SwordValidationInfoType.ERROR);
                        info.setContentDescription(value);
                        attributeItems.add(info);
                        success = false;
                    }
                    if (!success) continue;
                    info = new SwordValidationInfo(this.xmlName, new XmlName(attribute));
                    info.setContentDescription(this.type.toString());
                    attributeItems.add(info);
                    continue;
                }
                SwordValidationInfo info = new SwordValidationInfo(this.xmlName, new XmlName(attribute), "This attribute is present, but it is not used as part of the SWORD profile", SwordValidationInfoType.INFO);
                info.setContentDescription(attribute.getValue());
                attributeItems.add(info);
            }
            int length = text.getChildCount();
            if (length > 0) {
                this.content = this.unmarshallString(text);
            }
        }
        catch (Exception ex) {
            log.error("Unable to parse an element in " + this.getQualifiedName() + ": " + ex.getMessage());
            throw new UnmarshallException("Unable to parse an element in " + this.getQualifiedName(), ex);
        }
        SwordValidationInfo result = null;
        if (validationProperties != null) {
            result = this.validate(validationItems, attributeItems, validationProperties);
        }
        return result;
    }

    @Override
    public SwordValidationInfo validate(Properties validationContext) {
        return this.validate(null, null, validationContext);
    }

    protected SwordValidationInfo validate(List<SwordValidationInfo> existing, List<SwordValidationInfo> attributeItems, Properties validationContext) {
        boolean validateAll = existing == null;
        SwordValidationInfo result = new SwordValidationInfo(this.xmlName);
        result.setContentDescription(this.content);
        if (this.content == null) {
            result.addValidationInfo(new SwordValidationInfo(this.xmlName, "Missing content for element", SwordValidationInfoType.WARNING));
        }
        if (validateAll) {
            SwordValidationInfo info = new SwordValidationInfo(this.xmlName, new XmlName(this.xmlName.getPrefix(), ATTRIBUTE_TYPE, this.xmlName.getNamespace()));
            info.setContentDescription(this.type.toString());
            result.addAttributeValidationInfo(info);
        }
        result.addUnmarshallValidationInfo(existing, attributeItems);
        return result;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public ContentType getType() {
        return this.type;
    }

    public void setType(ContentType type) {
        this.type = type;
    }

    public String toString() {
        return "Summary - content: " + this.getContent() + " type: " + this.getType();
    }
}

