/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.sword.ATOMCollectionGenerator;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.SWORDConfiguration;
import org.dspace.sword.SWORDService;
import org.dspace.sword.SWORDUrlManager;
import org.purl.sword.base.Collection;

public class CollectionCollectionGenerator
extends ATOMCollectionGenerator {
    private static final Logger log = LogManager.getLogger(CollectionCollectionGenerator.class);
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    private final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    public CollectionCollectionGenerator(SWORDService service) {
        super(service);
        log.debug("Create new instance of CollectionCollectionGenerator");
    }

    @Override
    public Collection buildCollection(DSpaceObject dso) throws DSpaceSWORDException {
        if (!(dso instanceof org.dspace.content.Collection)) {
            log.error("buildCollection passed argument which is not of type Collection");
            throw new DSpaceSWORDException("Incorrect ATOMCollectionGenerator instantiated");
        }
        SWORDConfiguration swordConfig = this.swordService.getSwordConfig();
        SWORDUrlManager urlManager = this.swordService.getUrlManager();
        org.dspace.content.Collection col = (org.dspace.content.Collection)dso;
        Collection scol = new Collection();
        String location = urlManager.getDepositLocation(col);
        String title = this.collectionService.getMetadataFirstValue((DSpaceObject)col, CollectionService.MD_NAME, "*");
        String collectionPolicy = this.collectionService.getLicense(col);
        String dcAbstract = this.collectionService.getMetadataFirstValue((DSpaceObject)col, CollectionService.MD_SHORT_DESCRIPTION, "*");
        boolean mediation = swordConfig.isMediated();
        scol.setLocation(location);
        if (title != null && !"".equals(title)) {
            scol.setTitle(title);
        }
        if (collectionPolicy != null && !"".equals(collectionPolicy)) {
            scol.setCollectionPolicy(collectionPolicy);
        }
        if (dcAbstract != null && !"".equals(dcAbstract)) {
            scol.setAbstract(dcAbstract);
        }
        scol.setMediation(mediation);
        List<String> accepts = this.swordService.getSwordConfig().getCollectionAccepts();
        for (String string : accepts) {
            scol.addAccepts(string);
        }
        Map<String, Float> aps = swordConfig.getAcceptPackaging(col);
        for (Map.Entry<String, Float> entry : aps.entrySet()) {
            scol.addAcceptPackaging(entry.getKey(), entry.getValue().floatValue());
        }
        boolean bl = this.configurationService.getBooleanProperty("sword-server.expose-items");
        if (bl) {
            String string = urlManager.constructSubServiceUrl(col);
            scol.setService(string);
        }
        log.debug("Created ATOM Collection for DSpace Collection");
        return scol;
    }
}

