/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.purl.sword.base.SWORDAuthenticationException;
import org.purl.sword.base.SWORDErrorException;
import org.purl.sword.base.SWORDException;
import org.purl.sword.base.ServiceDocument;
import org.purl.sword.base.ServiceDocumentRequest;
import org.purl.sword.server.SWORDServer;

public class ServiceDocumentServlet
extends HttpServlet {
    private transient SWORDServer myRepository;
    private String authN;
    private int maxUploadSize;
    private static final Logger log = LogManager.getLogger(ServiceDocumentServlet.class);

    public void init() throws ServletException {
        String className = this.getServletContext().getInitParameter("sword-server-class");
        if (className == null) {
            log.fatal("Unable to read value of 'sword-server-class' from Servlet context");
            throw new ServletException("Unable to read value of 'sword-server-class' from Servlet context");
        }
        try {
            this.myRepository = (SWORDServer)Class.forName(className).newInstance();
            log.info("Using " + className + " as the SWORDServer");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            log.fatal("Unable to instantiate class from 'server-class': " + className);
            throw new ServletException("Unable to instantiate class from 'server-class': " + className, (Throwable)e);
        }
        this.authN = this.getServletContext().getInitParameter("authentication-method");
        if (this.authN == null || "".equals(this.authN)) {
            this.authN = "None";
        }
        log.info("Authentication type set to: " + this.authN);
        String maxUploadSizeStr = this.getServletContext().getInitParameter("maxUploadSize");
        if (maxUploadSizeStr == null || maxUploadSizeStr.equals("") || maxUploadSizeStr.equals("-1")) {
            this.maxUploadSize = -1;
            log.warn("No maxUploadSize set, so setting max file upload size to unlimited.");
        } else {
            try {
                this.maxUploadSize = Integer.parseInt(maxUploadSizeStr);
                log.info("Setting max file upload size to " + this.maxUploadSize);
            }
            catch (NumberFormatException nfe) {
                this.maxUploadSize = -1;
                log.warn("maxUploadSize not a number, so setting max file upload size to unlimited.");
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServiceDocumentRequest sdr = new ServiceDocumentRequest();
        String usernamePassword = this.getUsernamePassword(request);
        if (usernamePassword != null && !usernamePassword.equals("")) {
            int p = usernamePassword.indexOf(58);
            if (p != -1) {
                sdr.setUsername(usernamePassword.substring(0, p));
                sdr.setPassword(usernamePassword.substring(p + 1));
            }
        } else if (this.authenticateWithBasic()) {
            String s = "Basic realm=\"SWORD\"";
            response.setHeader("WWW-Authenticate", s);
            response.setStatus(401);
            return;
        }
        sdr.setOnBehalfOf(request.getHeader("X-On-Behalf-Of"));
        sdr.setIPAddress(request.getRemoteAddr());
        sdr.setLocation(ServiceDocumentServlet.getUrl(request));
        try {
            ServiceDocument sd = this.myRepository.doServiceDocument(sdr);
            if (sd.getService().getMaxUploadSize() == -1 && this.maxUploadSize != -1) {
                sd.getService().setMaxUploadSize(this.maxUploadSize);
            }
            response.setContentType("application/atomsvc+xml; charset=UTF-8");
            PrintWriter out = response.getWriter();
            out.write(sd.marshall());
            out.flush();
        }
        catch (SWORDAuthenticationException sae) {
            if (this.authN.equals("Basic")) {
                String s = "Basic realm=\"SWORD\"";
                response.setHeader("WWW-Authenticate", s);
                response.setStatus(401);
            }
        }
        catch (SWORDErrorException see) {
            response.sendError(see.getStatus(), see.getDescription());
        }
        catch (SWORDException se) {
            log.error("Internal error", (Throwable)se);
            response.sendError(500, "Internal error (check logs for more information)");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendError(501);
    }

    private String getUsernamePassword(HttpServletRequest request) {
        try {
            String basic;
            StringTokenizer st;
            String authHeader = request.getHeader("Authorization");
            if (authHeader != null && (st = new StringTokenizer(authHeader)).hasMoreTokens() && (basic = st.nextToken()).equalsIgnoreCase("Basic")) {
                String credentials = st.nextToken();
                String userPass = new String(Base64.decodeBase64((byte[])credentials.getBytes()));
                return userPass;
            }
        }
        catch (Exception e) {
            log.debug(e.toString());
        }
        return null;
    }

    private boolean authenticateWithBasic() {
        return this.authN.equalsIgnoreCase("Basic");
    }

    private static String getUrl(HttpServletRequest req) {
        Object reqUrl = req.getRequestURL().toString();
        String queryString = req.getQueryString();
        log.debug("Requested url is: " + (String)reqUrl);
        if (queryString != null) {
            reqUrl = (String)reqUrl + "?" + queryString;
        }
        log.debug("Requested url with Query String is: " + (String)reqUrl);
        return reqUrl;
    }
}

