/*
 * Decompiled with CFR 0.152.
 */
package org.purl.sword.atom;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import nu.xom.Attribute;
import nu.xom.Element;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.purl.sword.base.SwordElementInterface;
import org.purl.sword.base.SwordValidationInfo;
import org.purl.sword.base.SwordValidationInfoType;
import org.purl.sword.base.UnmarshallException;
import org.purl.sword.base.XmlElement;
import org.purl.sword.base.XmlName;

public class Link
extends XmlElement
implements SwordElementInterface {
    public static final String ATTRIBUTE_HREF = "href";
    public static final String ATTRIBUTE_REL = "rel";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_HREF_LANG = "hreflang";
    public static final String ATTRIBUTE_TITLE = "title";
    public static final String ATTRIBUTE_LENGTH = "length";
    @Deprecated
    public static final String ELEMENT_NAME = "link";
    private String href;
    private String rel;
    private String type;
    private String hreflang;
    private String title;
    private String length;
    private String content;
    private static Logger log = LogManager.getLogger(Link.class);
    private static final XmlName XML_NAME = new XmlName("atom", "link", "http://www.w3.org/2005/Atom");

    public Link() {
        super(XML_NAME);
    }

    public static XmlName elementName() {
        return XML_NAME;
    }

    @Override
    public Element marshall() {
        Element element = new Element(this.getQualifiedName(), this.xmlName.getNamespace());
        if (this.content != null) {
            element.appendChild(this.content);
        }
        if (this.href != null) {
            Attribute hrefAttribute = new Attribute(ATTRIBUTE_HREF, this.href);
            element.addAttribute(hrefAttribute);
        }
        if (this.rel != null) {
            Attribute relAttribute = new Attribute(ATTRIBUTE_REL, this.rel);
            element.addAttribute(relAttribute);
        }
        if (this.type != null) {
            Attribute typeAttribute = new Attribute(ATTRIBUTE_TYPE, this.type);
            element.addAttribute(typeAttribute);
        }
        if (this.hreflang != null) {
            Attribute hreflangAttribute = new Attribute(ATTRIBUTE_HREF_LANG, this.hreflang);
            element.addAttribute(hreflangAttribute);
        }
        if (this.title != null) {
            Attribute titleAttribute = new Attribute(ATTRIBUTE_TITLE, this.title);
            element.addAttribute(titleAttribute);
        }
        if (this.length != null) {
            Attribute lengthAttribute = new Attribute(ATTRIBUTE_LENGTH, this.length);
            element.addAttribute(lengthAttribute);
        }
        return element;
    }

    @Override
    public void unmarshall(Element link) throws UnmarshallException {
        this.unmarshall(link, null);
    }

    public SwordValidationInfo unmarshall(Element link, Properties validationProperties) throws UnmarshallException {
        if (!this.isInstanceOf(link, this.xmlName)) {
            return this.handleIncorrectElement(link, validationProperties);
        }
        ArrayList<SwordValidationInfo> validationItems = new ArrayList<SwordValidationInfo>();
        ArrayList<SwordValidationInfo> attributeItems = new ArrayList<SwordValidationInfo>();
        try {
            int attributeCount = link.getAttributeCount();
            Attribute attribute = null;
            for (int i = 0; i < attributeCount; ++i) {
                attribute = link.getAttribute(i);
                if (ATTRIBUTE_HREF.equals(attribute.getQualifiedName())) {
                    this.href = attribute.getValue();
                    if (validationProperties == null) continue;
                    attributeItems.add(this.createValidAttributeInfo(ATTRIBUTE_HREF, this.href));
                    continue;
                }
                if (ATTRIBUTE_REL.equals(attribute.getQualifiedName())) {
                    this.rel = attribute.getValue();
                    if (validationProperties == null) continue;
                    attributeItems.add(this.createValidAttributeInfo(ATTRIBUTE_REL, this.rel));
                    continue;
                }
                if (ATTRIBUTE_TYPE.equals(attribute.getQualifiedName())) {
                    this.type = attribute.getValue();
                    if (validationProperties == null) continue;
                    attributeItems.add(this.createValidAttributeInfo(ATTRIBUTE_TYPE, this.type));
                    continue;
                }
                if (ATTRIBUTE_HREF_LANG.equals(attribute.getQualifiedName())) {
                    this.hreflang = attribute.getValue();
                    if (validationProperties == null) continue;
                    attributeItems.add(this.createValidAttributeInfo(ATTRIBUTE_HREF_LANG, this.hreflang));
                    continue;
                }
                if (ATTRIBUTE_TITLE.equals(attribute.getQualifiedName())) {
                    this.title = attribute.getValue();
                    if (validationProperties == null) continue;
                    attributeItems.add(this.createValidAttributeInfo(ATTRIBUTE_TITLE, this.title));
                    continue;
                }
                if (ATTRIBUTE_LENGTH.equals(attribute.getQualifiedName())) {
                    this.length = attribute.getValue();
                    if (validationProperties == null) continue;
                    attributeItems.add(this.createValidAttributeInfo(ATTRIBUTE_LENGTH, this.length));
                    continue;
                }
                XmlName attributeName = new XmlName(attribute);
                SwordValidationInfo unknown = new SwordValidationInfo(this.xmlName, attributeName, "This attribute is present, but it is not used as part of the SWORD profile", SwordValidationInfoType.INFO);
                unknown.setContentDescription(attribute.getValue());
                attributeItems.add(unknown);
            }
            if (link.getChildCount() > 0) {
                SwordValidationInfo content = new SwordValidationInfo(this.xmlName, "This element has content, but it is not used by SWORD", SwordValidationInfoType.INFO);
                validationItems.add(content);
            }
        }
        catch (Exception ex) {
            log.error("Unable to parse an element in Link: " + ex.getMessage());
            throw new UnmarshallException("Unable to parse element in link", ex);
        }
        SwordValidationInfo result = null;
        if (validationProperties != null) {
            result = this.validate(validationItems, attributeItems, validationProperties);
        }
        return result;
    }

    @Override
    public SwordValidationInfo validate(Properties validationContext) {
        return this.validate(null, null, validationContext);
    }

    public SwordValidationInfo validate(List<SwordValidationInfo> elements, List<SwordValidationInfo> attributes, Properties validationContext) {
        boolean validateAll = elements == null;
        SwordValidationInfo result = new SwordValidationInfo(this.xmlName);
        if (this.href == null) {
            XmlName attributeName = new XmlName(this.xmlName.getPrefix(), ATTRIBUTE_HREF, this.xmlName.getNamespace());
            SwordValidationInfo item = new SwordValidationInfo(this.xmlName, attributeName, "This attribute is not present, but it SHOULD be included.", SwordValidationInfoType.ERROR);
            result.addAttributeValidationInfo(item);
        }
        if (validateAll) {
            if (this.href != null) {
                result.addAttributeValidationInfo(this.createValidAttributeInfo(ATTRIBUTE_HREF, this.href));
            }
            if (this.rel != null) {
                result.addAttributeValidationInfo(this.createValidAttributeInfo(ATTRIBUTE_REL, this.rel));
            }
            if (this.type != null) {
                result.addAttributeValidationInfo(this.createValidAttributeInfo(ATTRIBUTE_TYPE, this.type));
            }
            if (this.hreflang != null) {
                result.addAttributeValidationInfo(this.createValidAttributeInfo(ATTRIBUTE_HREF_LANG, this.hreflang));
            }
            if (this.title != null) {
                result.addAttributeValidationInfo(this.createValidAttributeInfo(ATTRIBUTE_TITLE, this.title));
            }
            if (this.length != null) {
                result.addAttributeValidationInfo(this.createValidAttributeInfo(ATTRIBUTE_LENGTH, this.length));
            }
        }
        result.addUnmarshallValidationInfo(elements, attributes);
        return result;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getRel() {
        return this.rel;
    }

    public void setRel(String rel) {
        this.rel = rel;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getHreflang() {
        return this.hreflang;
    }

    public void setHreflang(String hreflang) {
        this.hreflang = hreflang;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLength() {
        return this.length;
    }

    public void setLength(String length) {
        this.length = length;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String toString() {
        return "Link - href: " + this.getHref() + " hreflang: " + this.getHreflang() + " title: " + this.getTitle() + " rel: " + this.getRel() + " content: " + this.getContent() + " type: " + this.getType() + " length: " + this.getLength();
    }
}

