/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.sword.BitstreamEntryGenerator;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.SWORDService;
import org.dspace.sword.SWORDUrlManager;
import org.purl.sword.base.AtomDocumentResponse;
import org.purl.sword.base.SWORDEntry;
import org.purl.sword.base.SWORDErrorException;

public class MediaEntryManager {
    private SWORDService swordService;

    public MediaEntryManager(SWORDService swordService) {
        this.swordService = swordService;
    }

    public AtomDocumentResponse getMediaEntry(String url) throws DSpaceSWORDException, SWORDErrorException {
        SWORDUrlManager urlManager = this.swordService.getUrlManager();
        AtomDocumentResponse response = new AtomDocumentResponse(200);
        if (url == null || urlManager.isBaseMediaLinkUrl(url)) {
            throw new SWORDErrorException("http://www.dspace.org/ns/sword/1.3.1/errors/MediaUnavailable", "The media link you requested is not available");
        }
        DSpaceObject dso = urlManager.extractDSpaceObject(url);
        if (!(dso instanceof Bitstream)) {
            throw new SWORDErrorException("http://www.dspace.org/ns/sword/1.3.1/errors/BadUrl", "The url you provided does not resolve to an appropriate object");
        }
        BitstreamEntryGenerator dsatom = new BitstreamEntryGenerator(this.swordService);
        SWORDEntry entry = dsatom.getSWORDEntry(dso);
        response.setEntry(entry);
        return response;
    }
}

