/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.sword;

import org.dspace.content.Bitstream;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.sword.DSpaceSWORDException;
import org.dspace.sword.DepositResult;
import org.dspace.sword.SWORDService;
import org.dspace.sword.SWORDUrlManager;
import org.purl.sword.atom.Author;
import org.purl.sword.atom.Contributor;
import org.purl.sword.atom.Generator;
import org.purl.sword.base.Deposit;
import org.purl.sword.base.SWORDEntry;

public abstract class DSpaceATOMEntry {
    protected SWORDEntry entry;
    protected Item item = null;
    protected Bitstream bitstream = null;
    protected DepositResult result = null;
    protected SWORDService swordService;
    protected Deposit deposit = null;

    protected DSpaceATOMEntry(SWORDService service) {
        this.swordService = service;
    }

    public void reset() {
        this.entry = new SWORDEntry();
        this.item = null;
        this.bitstream = null;
        this.result = null;
        this.deposit = null;
    }

    public SWORDEntry getSWORDEntry(DSpaceObject dso) throws DSpaceSWORDException {
        this.reset();
        if (!(dso instanceof Bitstream)) {
            throw new DSpaceSWORDException("Can only recover a sword entry for a bitstream via this method");
        }
        this.bitstream = (Bitstream)dso;
        this.constructEntry();
        return this.entry;
    }

    public SWORDEntry getSWORDEntry(DepositResult result, Deposit deposit) throws DSpaceSWORDException {
        this.reset();
        this.entry = new SWORDEntry();
        this.item = result.getItem();
        this.bitstream = result.getBitstream();
        this.result = result;
        this.deposit = deposit;
        this.constructEntry();
        return this.entry;
    }

    protected void constructEntry() throws DSpaceSWORDException {
        this.addGenerator();
        this.addAuthors();
        this.addCategories();
        this.addContentElement();
        this.addPackagingElement();
        this.addContributors();
        this.addIdentifier();
        this.addLinks();
        this.addPublishDate();
        this.addRights();
        this.addSummary();
        this.addTitle();
        this.addLastUpdatedDate();
        this.addTreatment();
    }

    protected void addTreatment() {
        if (this.result != null) {
            this.entry.setTreatment(this.result.getTreatment());
        }
    }

    protected void addGenerator() {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        boolean identify = configurationService.getBooleanProperty("sword-server.identify-version");
        SWORDUrlManager urlManager = this.swordService.getUrlManager();
        String softwareUri = urlManager.getGeneratorUrl();
        if (identify) {
            Generator generator = new Generator();
            generator.setUri(softwareUri);
            generator.setVersion("1.3");
            this.entry.setGenerator(generator);
        }
    }

    protected void addPackagingElement() {
        if (this.deposit != null) {
            this.entry.setPackaging(this.deposit.getPackaging());
        }
    }

    protected void addAuthors() {
        if (this.deposit != null) {
            String username = this.deposit.getUsername();
            Author author = new Author();
            author.setName(username);
            this.entry.addAuthors(author);
        }
    }

    protected void addContributors() {
        String obo;
        if (this.deposit != null && (obo = this.deposit.getOnBehalfOf()) != null) {
            Contributor cont = new Contributor();
            cont.setName(obo);
            this.entry.addContributor(cont);
        }
    }

    abstract void addCategories() throws DSpaceSWORDException;

    abstract void addContentElement() throws DSpaceSWORDException;

    abstract void addIdentifier() throws DSpaceSWORDException;

    abstract void addLinks() throws DSpaceSWORDException;

    abstract void addPublishDate() throws DSpaceSWORDException;

    abstract void addRights() throws DSpaceSWORDException;

    abstract void addSummary() throws DSpaceSWORDException;

    abstract void addTitle() throws DSpaceSWORDException;

    abstract void addLastUpdatedDate() throws DSpaceSWORDException;
}

