/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.servicemanager.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DSpaceEnvironmentConfiguration
extends MapConfiguration {
    private static final Logger log = LogManager.getLogger();

    public DSpaceEnvironmentConfiguration() {
        super(DSpaceEnvironmentConfiguration.getModifiedEnvMap());
    }

    public static Map<String, Object> getModifiedEnvMap() {
        HashMap<String, Object> env = new HashMap<String, Object>(System.getenv().size());
        for (String key : System.getenv().keySet()) {
            if (!StringUtils.contains((CharSequence)key, (CharSequence)"__")) continue;
            String lookup = StringUtils.replace((String)key, (String)"__P__", (String)".");
            lookup = StringUtils.replace((String)lookup, (String)"__D__", (String)"-");
            String value = System.getenv(key);
            if (value != null) {
                env.put(lookup, value);
                log.debug("Found env {} = {}.", (Object)lookup, (Object)value);
                continue;
            }
            log.debug("Didn't find env {}.", (Object)lookup);
        }
        return env;
    }

    protected void addPropertyDirect(String key, Object value) {
        throw new UnsupportedOperationException("EnvironmentConfiguration is read-only!");
    }

    protected void clearPropertyDirect(String key) {
        throw new UnsupportedOperationException("EnvironmentConfiguration is read-only!");
    }

    protected void clearInternal() {
        throw new UnsupportedOperationException("EnvironmentConfiguration is read-only!");
    }
}

