/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.kernel;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.kernel.DSpaceKernel;

public final class DSpaceKernelManager {
    private static final Logger log = LogManager.getLogger();
    private static DSpaceKernel defaultKernel = null;
    private static final Map<String, DSpaceKernel> namedKernelMap = new HashMap<String, DSpaceKernel>();
    private final Object lock = new Object();
    private static final String defaultKernelName = UUID.randomUUID().toString();

    public static DSpaceKernel getDefaultKernel() {
        return defaultKernel;
    }

    public static void setDefaultKernel(DSpaceKernel kernel) {
        defaultKernel = kernel;
    }

    public DSpaceKernel getKernel() {
        DSpaceKernel kernel = this.getKernel(null);
        if (kernel == null) {
            throw new IllegalStateException("The DSpace kernel is not started yet, please start it before attempting to use it");
        }
        return kernel;
    }

    public DSpaceKernel getKernel(String name) {
        if (!StringUtils.isEmpty((CharSequence)name)) {
            String checkedName = DSpaceKernelManager.checkName(name);
            if (namedKernelMap.containsKey(checkedName)) {
                return namedKernelMap.get(checkedName);
            }
            if (defaultKernel != null && checkedName.equals(defaultKernel.getMBeanName())) {
                return defaultKernel;
            }
            Object object = this.lock;
            synchronized (object) {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                try {
                    ObjectName kernelName = new ObjectName(checkedName);
                    DSpaceKernel namedKernel = (DSpaceKernel)mbs.invoke(kernelName, "getManagedBean", null, null);
                    if (namedKernel == null || !namedKernel.isRunning()) {
                        throw new IllegalStateException("The DSpace kernel is not started yet, please start it before attempting to use it");
                    }
                    namedKernelMap.put(checkedName, namedKernel);
                    return namedKernel;
                }
                catch (InstanceNotFoundException e) {
                    throw new IllegalStateException(e);
                }
                catch (MBeanException e) {
                    throw new IllegalStateException(e);
                }
                catch (ReflectionException e) {
                    throw new IllegalStateException(e);
                }
                catch (MalformedObjectNameException e) {
                    throw new IllegalStateException(e);
                }
                catch (NullPointerException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        return defaultKernel;
    }

    public static String checkName(String name) {
        Object mbeanName = name;
        if (name == null || "".equals(name)) {
            mbeanName = "org.dspace:name=" + defaultKernelName + ",type=DSpaceKernel";
        } else if (!name.startsWith("org.dspace:name=")) {
            mbeanName = "org.dspace:name=" + name + ",type=DSpaceKernel";
        }
        return mbeanName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerMBean(String mBeanName, DSpaceKernel kernel) {
        String checkedMBeanName = DSpaceKernelManager.checkName(mBeanName);
        String string = mBeanName;
        synchronized (string) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectName name = new ObjectName(checkedMBeanName);
                if (!mbs.isRegistered(name)) {
                    mbs.registerMBean(kernel, name);
                    log.info("Registered new Kernel MBEAN: {} [{}]", (Object)checkedMBeanName, (Object)kernel);
                }
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalStateException(e);
            }
            catch (InstanceAlreadyExistsException e) {
                throw new IllegalStateException(e);
            }
            catch (MBeanRegistrationException e) {
                throw new IllegalStateException(e);
            }
            catch (NotCompliantMBeanException e) {
                throw new IllegalStateException(e);
            }
            catch (NullPointerException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unregisterMBean(String mBeanName) {
        String checkedMBeanName = DSpaceKernelManager.checkName(mBeanName);
        String string = mBeanName;
        synchronized (string) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            try {
                mbs.unregisterMBean(new ObjectName(checkedMBeanName));
                return true;
            }
            catch (InstanceNotFoundException ie) {
                return true;
            }
            catch (Exception e) {
                log.warn("Failed to unregister the MBean: {}", (Object)checkedMBeanName, (Object)e);
                return false;
            }
        }
    }
}

