/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.services.events;

import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.ArrayUtils;
import org.dspace.services.EventService;
import org.dspace.services.RequestService;
import org.dspace.services.model.Event;
import org.dspace.services.model.EventListener;
import org.dspace.services.model.RequestInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public final class SystemEventService
implements EventService {
    private final Logger log = LoggerFactory.getLogger(SystemEventService.class);
    private final Map<String, EventListener> listenersMap = new ConcurrentHashMap<String, EventListener>();
    private final RequestService requestService;
    private EventRequestInterceptor requestInterceptor;
    private final Random random = new Random();

    @Autowired(required=true)
    public SystemEventService(RequestService requestService) {
        if (requestService == null) {
            throw new IllegalArgumentException("requestService and all inputs must not be null");
        }
        this.requestService = requestService;
        this.requestInterceptor = new EventRequestInterceptor();
        this.requestService.registerRequestInterceptor(this.requestInterceptor);
    }

    @PreDestroy
    public void shutdown() {
        this.requestInterceptor = null;
        this.listenersMap.clear();
    }

    @Override
    public void fireEvent(Event event) {
        boolean external;
        boolean cluster;
        this.validateEvent(event);
        Event.Scope[] scopes = event.getScopes();
        boolean local = ArrayUtils.contains((Object[])scopes, (Object)((Object)Event.Scope.LOCAL));
        if (local) {
            this.fireLocalEvent(event);
        }
        if (cluster = ArrayUtils.contains((Object[])scopes, (Object)((Object)Event.Scope.CLUSTER))) {
            this.fireClusterEvent(event);
        }
        if (external = ArrayUtils.contains((Object[])scopes, (Object)((Object)Event.Scope.EXTERNAL))) {
            this.fireExternalEvent(event);
        }
    }

    @Override
    public void registerEventListener(EventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Cannot register a listener that is null");
        }
        String key = listener.getClass().getName();
        this.listenersMap.put(key, listener);
    }

    private void fireLocalEvent(Event event) {
        for (EventListener listener : this.listenersMap.values()) {
            if (listener == null || !this.filterEvent(listener, event)) continue;
            try {
                listener.receiveEvent(event);
            }
            catch (Exception e) {
                this.log.warn("Listener ({})[{}] failed to receive event ({}): {}:{}", new Object[]{listener, listener.getClass().getName(), event, e.getMessage(), e.getCause()});
            }
        }
    }

    private void fireClusterEvent(Event event) {
        this.log.debug("fireClusterEvent is not implemented yet, no support for cluster events yet, could not fire event to the cluster: " + event);
    }

    private void fireExternalEvent(Event event) {
        this.log.debug("fireExternalEvent is not implemented yet, no support for external events yet, could not fire event to external listeners: " + event);
    }

    private void validateEvent(Event event) {
        if (event == null) {
            throw new IllegalArgumentException("Cannot fire null events");
        }
        if (event.getName() == null || "".equals(event.getName())) {
            throw new IllegalArgumentException("Event name must be set");
        }
        if (event.getId() == null || "".equals(event.getId())) {
            event.setId(this.makeEventId());
        }
        if (event.getUserId() == null || "".equals(event.getUserId())) {
            String userId = this.requestService.getCurrentUserId();
            event.setUserId(userId);
        }
        if (event.getScopes() == null) {
            event.setScopes(new Event.Scope[]{Event.Scope.LOCAL, Event.Scope.CLUSTER});
        }
    }

    private boolean filterEvent(EventListener listener, Event event) {
        boolean allowName;
        block10: {
            if (listener == null || event == null) {
                return false;
            }
            allowName = true;
            try {
                String[] namePrefixes = listener.getEventNamePrefixes();
                if (namePrefixes == null || namePrefixes.length <= 0) break block10;
                allowName = false;
                for (String namePrefix : namePrefixes) {
                    String eventName = event.getName();
                    if (namePrefix == null || namePrefix.length() <= 0 || !eventName.startsWith(namePrefix)) continue;
                    allowName = true;
                    break;
                }
            }
            catch (Exception e1) {
                this.log.warn("Listener ({})[{}] failure calling getEventNamePrefixes: {}:{}", new Object[]{listener, listener.getClass().getName(), e1.getMessage(), e1.getCause()});
            }
        }
        boolean allowResource = true;
        try {
            String resourcePrefix = listener.getResourcePrefix();
            if (resourcePrefix != null && resourcePrefix.length() > 0) {
                allowResource = false;
                String resRef = event.getResourceReference();
                if (resRef == null) {
                    allowResource = true;
                } else if (resRef.startsWith(resourcePrefix)) {
                    allowResource = true;
                }
            }
        }
        catch (Exception e1) {
            this.log.warn("Listener ({})[{}] failure calling getResourcePrefix: {}:{}", new Object[]{listener, listener.getClass().getName(), e1.getMessage(), e1.getCause()});
        }
        return allowName && allowResource;
    }

    private String makeEventId() {
        return "event-" + this.random.nextInt(1000) + "-" + System.currentTimeMillis();
    }

    public final class EventRequestInterceptor
    implements RequestInterceptor {
        @Override
        public void onStart(String requestId) {
        }

        @Override
        public void onEnd(String requestId, boolean succeeded, Exception failure) {
        }

        @Override
        public int getOrder() {
            return 20;
        }
    }
}

