/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.services.sessions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.dspace.services.ConfigurationService;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.dspace.services.model.RequestInterceptor;
import org.dspace.services.sessions.model.HttpRequestImpl;
import org.dspace.services.sessions.model.InternalRequestImpl;
import org.dspace.utils.servicemanager.OrderedServiceComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public final class StatelessRequestServiceImpl
implements RequestService {
    private static final Logger log = LoggerFactory.getLogger(StatelessRequestServiceImpl.class);
    private ConfigurationService configurationService;
    private final Map<String, RequestInterceptor> interceptorsMap = new HashMap<String, RequestInterceptor>();
    private final RequestHolder requests = new RequestHolder();

    @Autowired(required=true)
    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    @PostConstruct
    public void init() {
        log.info("init");
    }

    @PreDestroy
    public void shutdown() {
        log.info("shutdown");
        this.clear();
    }

    public void clear() {
        this.requests.clear();
        this.interceptorsMap.clear();
    }

    @Override
    public String startRequest() {
        return this.startRequest(new InternalRequestImpl());
    }

    @Override
    public String startRequest(ServletRequest request, ServletResponse response) {
        return this.startRequest(new HttpRequestImpl(request, response));
    }

    private String startRequest(Request req) {
        List<RequestInterceptor> interceptors = this.getInterceptors(false);
        for (RequestInterceptor requestInterceptor : interceptors) {
            if (requestInterceptor == null) continue;
            try {
                requestInterceptor.onStart(req.getRequestId());
            }
            catch (RequestInterceptor.RequestInterruptionException e) {
                String message = "Request stopped from starting by exception from the interceptor (" + requestInterceptor + "): " + e.getMessage();
                log.warn(message);
                throw new RequestInterceptor.RequestInterruptionException(message, e);
            }
            catch (Exception e) {
                log.warn("Request interceptor (" + requestInterceptor + ") failed to execute on start (" + req.getRequestId() + "): " + e.getMessage());
            }
        }
        this.requests.setCurrent(req);
        return req.getRequestId();
    }

    @Override
    public String endRequest(Exception failure) {
        String requestId = null;
        try {
            requestId = this.getCurrentRequestId();
            if (StringUtils.isEmpty((CharSequence)requestId)) {
                log.debug("Attempting to end a request when none currently exists");
            } else {
                this.endRequest(requestId, failure);
            }
        }
        finally {
            this.requests.removeCurrent();
        }
        return requestId;
    }

    private void endRequest(String requestId, Exception failure) {
        if (requestId != null) {
            List<RequestInterceptor> interceptors = this.getInterceptors(true);
            for (RequestInterceptor requestInterceptor : interceptors) {
                if (requestInterceptor == null) continue;
                try {
                    requestInterceptor.onEnd(requestId, failure == null, failure);
                }
                catch (RequestInterceptor.RequestInterruptionException e) {
                    log.warn("Attempt to stop request from ending by an exception from the interceptor (" + requestInterceptor + "), cannot stop requests from ending though so request end continues, this may be an error: " + e.getMessage());
                }
                catch (Exception e) {
                    log.warn("Request interceptor (" + requestInterceptor + ") failed to execute on end (" + requestId + "): " + e.getMessage());
                }
            }
        }
    }

    private List<RequestInterceptor> getInterceptors(boolean reverse) {
        ArrayList<RequestInterceptor> l = new ArrayList<RequestInterceptor>(this.interceptorsMap.values());
        OrderedServiceComparator comparator = new OrderedServiceComparator();
        Collections.sort(l, comparator);
        if (reverse) {
            Collections.reverse(l);
        }
        return l;
    }

    @Override
    public void registerRequestInterceptor(RequestInterceptor interceptor) {
        if (interceptor == null) {
            throw new IllegalArgumentException("Cannot register an interceptor that is null");
        }
        if (interceptor.getOrder() <= 0) {
            throw new IllegalArgumentException("Interceptor ordering for RequestInterceptor's must be greater than 0");
        }
        String key = interceptor.getOrder() + ":" + interceptor.getClass().getName();
        this.interceptorsMap.put(key, interceptor);
    }

    @Override
    public String getCurrentUserId() {
        Request currentRequest = this.getCurrentRequest();
        if (currentRequest == null) {
            return null;
        }
        return Objects.toString(currentRequest.getAttribute("authenticated_eperson"));
    }

    @Override
    public void setCurrentUserId(UUID epersonId) {
        Request currentRequest = this.getCurrentRequest();
        if (currentRequest != null) {
            this.getCurrentRequest().setAttribute("authenticated_eperson", epersonId);
        }
    }

    @Override
    public String getCurrentRequestId() {
        Request req = this.requests.getCurrent();
        if (req != null) {
            return req.getRequestId();
        }
        return null;
    }

    @Override
    public Request getCurrentRequest() {
        return this.requests.getCurrent();
    }

    private class RequestHolder {
        Map<Long, Request> requestMap = new ConcurrentHashMap<Long, Request>();

        private RequestHolder() {
        }

        Request getCurrent() {
            return this.requestMap.get(Thread.currentThread().getId());
        }

        void setCurrent(Request req) {
            this.requestMap.put(Thread.currentThread().getId(), req);
        }

        void removeCurrent() {
            this.requestMap.remove(Thread.currentThread().getId());
        }

        Request get(String requestId) {
            if (!StringUtils.isEmpty((CharSequence)requestId)) {
                for (Request req : this.requestMap.values()) {
                    if (req == null || !requestId.equals(req.getRequestId())) continue;
                    return req;
                }
            }
            return null;
        }

        void remove(String requestId) {
            if (!StringUtils.isEmpty((CharSequence)requestId)) {
                for (Map.Entry<Long, Request> reqEntry : this.requestMap.entrySet()) {
                    if (reqEntry.getValue() == null || !requestId.equals(reqEntry.getValue().getRequestId())) continue;
                    this.requestMap.remove(reqEntry.getKey());
                }
            }
        }

        void clear() {
            for (Request request : this.requestMap.values()) {
                try {
                    StatelessRequestServiceImpl.this.endRequest(request.getRequestId(), null);
                }
                catch (RuntimeException e) {
                    log.error("Runtime exception ending request", (Throwable)e);
                }
                catch (Exception e) {
                    log.error("Exception ending request", (Throwable)e);
                }
            }
            this.requestMap.clear();
        }
    }
}

