/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.step.validation;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.model.ErrorRest;
import org.dspace.app.rest.submit.SubmissionService;
import org.dspace.app.rest.submit.step.validation.AbstractValidation;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.app.util.DCInput;
import org.dspace.app.util.DCInputSet;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.MetadataValue;
import org.dspace.content.authority.service.MetadataAuthorityService;
import org.dspace.content.service.ItemService;
import org.dspace.services.ConfigurationService;

public class MetadataValidation
extends AbstractValidation {
    private static final String ERROR_VALIDATION_REQUIRED = "error.validation.required";
    private static final String ERROR_VALIDATION_AUTHORITY_REQUIRED = "error.validation.authority.required";
    private static final String ERROR_VALIDATION_REGEX = "error.validation.regex";
    private static final Logger log = LogManager.getLogger(MetadataValidation.class);
    private DCInputsReader inputReader;
    private ItemService itemService;
    private MetadataAuthorityService metadataAuthorityService;
    private ConfigurationService configurationService;

    public List<ErrorRest> validate(SubmissionService submissionService, InProgressSubmission obj, SubmissionStepConfig config) throws DCInputsReaderException, SQLException {
        ArrayList<ErrorRest> errors = new ArrayList<ErrorRest>();
        String documentTypeValue = "";
        DCInputSet inputConfig = this.getInputReader().getInputsByFormName(config.getId());
        List documentType = this.itemService.getMetadataByMetadataString((DSpaceObject)obj.getItem(), this.configurationService.getProperty("submit.type-bind.field", "dc.type"));
        if (documentType.size() > 0) {
            documentTypeValue = ((MetadataValue)documentType.get(0)).getValue();
        }
        List allowedFieldNames = inputConfig.populateAllowedFieldNames(documentTypeValue);
        DCInput[][] dCInputArray = inputConfig.getFields();
        int n = dCInputArray.length;
        for (int i = 0; i < n; ++i) {
            DCInput[] row;
            for (DCInput input : row = dCInputArray[i]) {
                String fieldKey = this.metadataAuthorityService.makeFieldKey(input.getSchema(), input.getElement(), input.getQualifier());
                boolean isAuthorityControlled = this.metadataAuthorityService.isAuthorityControlled(fieldKey);
                ArrayList<String> fieldsName = new ArrayList<String>();
                if (input.isQualdropValue()) {
                    boolean foundResult = false;
                    List inputPairs = input.getPairs();
                    for (int i2 = 1; i2 < inputPairs.size(); i2 += 2) {
                        String fullFieldname = input.getFieldName() + "." + (String)inputPairs.get(i2);
                        List mdv = this.itemService.getMetadataByMetadataString((DSpaceObject)obj.getItem(), fullFieldname);
                        if (!(input.isAllowedFor(documentTypeValue) || allowedFieldNames.contains(fullFieldname) || allowedFieldNames.contains(input.getFieldName()))) {
                            this.itemService.removeMetadataValues(ContextUtil.obtainCurrentRequestContext(), (DSpaceObject)obj.getItem(), mdv);
                            continue;
                        }
                        this.validateMetadataValues(mdv, input, config, isAuthorityControlled, fieldKey, errors);
                        if (mdv.size() <= 0 || !input.isVisible("submission")) continue;
                        foundResult = true;
                    }
                    if (input.isRequired() && !foundResult) {
                        this.addError(errors, ERROR_VALIDATION_REQUIRED, "/sections/" + config.getId() + "/" + input.getFieldName());
                    }
                } else {
                    String fieldName = input.getFieldName();
                    if (fieldName != null) {
                        fieldsName.add(fieldName);
                    }
                }
                for (String fieldName : fieldsName) {
                    boolean valuesRemoved = false;
                    List mdv = this.itemService.getMetadataByMetadataString((DSpaceObject)obj.getItem(), fieldName);
                    if (!input.isAllowedFor(documentTypeValue)) {
                        if (!allowedFieldNames.contains(fieldName)) {
                            this.itemService.removeMetadataValues(ContextUtil.obtainCurrentRequestContext(), (DSpaceObject)obj.getItem(), mdv);
                            valuesRemoved = true;
                            log.debug("Stripping metadata values for " + input.getFieldName() + " on type " + documentTypeValue + " as it is allowed by another input of the same field name");
                        } else {
                            log.debug("Not removing unallowed metadata values for " + input.getFieldName() + " on type " + documentTypeValue + " as it is allowed by another input of the same field name");
                        }
                    }
                    this.validateMetadataValues(mdv, input, config, isAuthorityControlled, fieldKey, errors);
                    if (!input.isRequired() || mdv.size() != 0 || !input.isVisible("submission") || valuesRemoved || !input.isAllowedFor(documentTypeValue)) continue;
                    this.addError(errors, ERROR_VALIDATION_REQUIRED, "/sections/" + config.getId() + "/" + input.getFieldName());
                }
            }
        }
        return errors;
    }

    private void validateMetadataValues(List<MetadataValue> mdv, DCInput input, SubmissionStepConfig config, boolean isAuthorityControlled, String fieldKey, List<ErrorRest> errors) {
        for (MetadataValue md : mdv) {
            if (!input.validate(md.getValue())) {
                this.addError(errors, ERROR_VALIDATION_REGEX, "/sections/" + config.getId() + "/" + input.getFieldName() + "/" + md.getPlace());
            }
            if (!isAuthorityControlled) continue;
            String authKey = md.getAuthority();
            if (!this.metadataAuthorityService.isAuthorityRequired(fieldKey) || !StringUtils.isBlank((CharSequence)authKey)) continue;
            this.addError(errors, ERROR_VALIDATION_AUTHORITY_REQUIRED, "/sections/" + config.getId() + "/" + input.getFieldName() + "/" + md.getPlace());
        }
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setItemService(ItemService itemService) {
        this.itemService = itemService;
    }

    public void setMetadataAuthorityService(MetadataAuthorityService metadataAuthorityService) {
        this.metadataAuthorityService = metadataAuthorityService;
    }

    public DCInputsReader getInputReader() {
        if (this.inputReader == null) {
            try {
                this.inputReader = new DCInputsReader();
            }
            catch (DCInputsReaderException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.inputReader;
    }

    public void setInputReader(DCInputsReader inputReader) {
        this.inputReader = inputReader;
    }
}

