/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.security.RestObjectPermissionEvaluatorPlugin;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.util.UUIDUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class SuggestionRestPermissionEvaluatorPlugin
extends RestObjectPermissionEvaluatorPlugin {
    @Autowired
    private ItemService itemService;

    @Override
    public boolean hasDSpacePermission(Authentication authentication, Serializable targetId, String targetType, DSpaceRestPermission restPermission) {
        if (!(DSpaceRestPermission.READ.equals((Object)restPermission) || DSpaceRestPermission.WRITE.equals((Object)restPermission) || DSpaceRestPermission.DELETE.equals((Object)restPermission))) {
            return false;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)targetType, (CharSequence)"suggestion") && !StringUtils.startsWithIgnoreCase((CharSequence)targetType, (CharSequence)"suggestion")) {
            return false;
        }
        Context context = ContextUtil.obtainCurrentRequestContext();
        EPerson currentUser = context.getCurrentUser();
        if (currentUser == null) {
            return false;
        }
        try {
            List mvalues;
            String id = targetId.toString();
            UUID uuid = null;
            uuid = id.contains(":") ? UUIDUtils.fromString((String)id.split(":", 3)[1]) : UUIDUtils.fromString((String)id);
            if (uuid == null) {
                return false;
            }
            Item item = (Item)this.itemService.find(context, uuid);
            if (item != null && (mvalues = this.itemService.getMetadataByMetadataString((DSpaceObject)item, "dspace.object.owner")) != null) {
                for (MetadataValue mv : mvalues) {
                    if (!StringUtils.equals((CharSequence)mv.getAuthority(), (CharSequence)currentUser.getID().toString())) continue;
                    return true;
                }
            }
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }
}

