/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation.resourcePolicy;

import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.app.rest.repository.patch.operation.resourcePolicy.ResourcePolicyUtils;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResourcePolicyStartDateRemoveOperation<R>
extends PatchOperation<R> {
    @Autowired
    ResourcePolicyUtils resourcePolicyUtils;

    @Override
    public R perform(Context context, R resource, Operation operation) {
        if (this.supports(resource, operation)) {
            ResourcePolicy resourcePolicy = (ResourcePolicy)resource;
            this.resourcePolicyUtils.checkResourcePolicyForExistingStartDateValue(resourcePolicy, operation);
            this.delete(resourcePolicy);
            return resource;
        }
        throw new DSpaceBadRequestException(this.getClass() + " does not support this operation");
    }

    private void delete(ResourcePolicy resourcePolicy) {
        resourcePolicy.setStartDate(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        if (!(objectToMatch instanceof ResourcePolicy)) return false;
        if (!operation.getOp().trim().equalsIgnoreCase("remove")) return false;
        if (!operation.getPath().trim().equalsIgnoreCase("/startDate")) return false;
        return true;
    }
}

