/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import org.dspace.app.rest.model.SupervisionOrderRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.supervision.service.SupervisionOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="submission.workspaceitems.supervisionOrders")
public class WorkspaceItemSupervisionOrdersLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    WorkspaceItemService workspaceItemService;
    @Autowired
    SupervisionOrderService supervisionOrderService;

    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<SupervisionOrderRest> getSupervisionOrders(@Nullable HttpServletRequest request, Integer id, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            WorkspaceItem workspaceItem = this.workspaceItemService.find(context, id.intValue());
            if (workspaceItem == null) {
                throw new ResourceNotFoundException("No such workspace item: " + id);
            }
            return this.converter.toRestPage(this.supervisionOrderService.findByItem(context, workspaceItem.getItem()), optionalPageable, projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

