/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.model.WorkflowStepRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.core.Context;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.state.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="config.workflowsteps")
public class WorkflowStepRestRepository
extends DSpaceRestRepository<WorkflowStepRest, String> {
    @Autowired
    protected XmlWorkflowFactory xmlWorkflowFactory;

    @Override
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public WorkflowStepRest findOne(Context context, String workflowStepName) {
        Step step = this.xmlWorkflowFactory.getStepByName(workflowStepName);
        if (step != null) {
            return (WorkflowStepRest)this.converter.toRest(step, this.utils.obtainProjection());
        }
        throw new ResourceNotFoundException("No workflow step with name " + workflowStepName + " is configured");
    }

    @Override
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<WorkflowStepRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("workflowstep", "findAll");
    }

    @Override
    public Class<WorkflowStepRest> getDomainClass() {
        return WorkflowStepRest.class;
    }
}

