/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import org.dspace.app.ldn.ItemFilter;
import org.dspace.app.rest.model.ItemFilterRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.content.ItemFilterService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="config.itemfilters")
public class ItemFilterRestRepository
extends DSpaceRestRepository<ItemFilterRest, String> {
    @Autowired
    private ItemFilterService itemFilterService;

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    public ItemFilterRest findOne(Context context, String id) {
        ItemFilter itemFilter = this.itemFilterService.findOne(id);
        if (itemFilter == null) {
            throw new ResourceNotFoundException("No such logical item filter: " + id);
        }
        return (ItemFilterRest)this.converter.toRest(itemFilter, this.utils.obtainProjection());
    }

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<ItemFilterRest> findAll(Context context, Pageable pageable) {
        return this.converter.toRestPage(this.itemFilterService.findAll(), pageable, this.utils.obtainProjection());
    }

    @Override
    public Class<ItemFilterRest> getDomainClass() {
        return ItemFilterRest.class;
    }
}

