/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.UUID;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.Community;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.communities.logo")
public class CommunityLogoLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    CommunityService communityService;

    @PreAuthorize(value="hasPermission(#communityId, 'COMMUNITY', 'READ')")
    public BitstreamRest getLogo(@Nullable HttpServletRequest request, UUID communityId, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            Community community = (Community)this.communityService.find(context, communityId);
            if (community == null) {
                throw new ResourceNotFoundException("No such community: " + communityId);
            }
            if (community.getLogo() == null) {
                return null;
            }
            return (BitstreamRest)this.converter.toRest(community.getLogo(), projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

