/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.link.search;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.dspace.app.rest.DiscoveryRestController;
import org.dspace.app.rest.link.search.DiscoveryRestHalLinkFactory;
import org.dspace.app.rest.model.DiscoveryResultsRest;
import org.dspace.app.rest.model.SearchFacetEntryRest;
import org.dspace.app.rest.model.hateoas.EmbeddedPageHeader;
import org.dspace.app.rest.model.hateoas.SearchFacetEntryResource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class SearchFacetEntryHalLinkFactory
extends DiscoveryRestHalLinkFactory<SearchFacetEntryResource> {
    @Override
    protected void addLinks(SearchFacetEntryResource halResource, Pageable pageable, LinkedList<Link> list) throws Exception {
        SearchFacetEntryRest facetData = halResource.getFacetData();
        DiscoveryResultsRest searchData = halResource.getSearchData();
        String query = searchData == null ? null : searchData.getQuery();
        List<String> dsoType = searchData == null ? null : searchData.getDsoTypes();
        String scope = searchData == null ? null : searchData.getScope();
        String configuration = searchData == null ? null : searchData.getConfiguration();
        UriComponentsBuilder uriBuilder = this.uriBuilder(((DiscoveryRestController)this.getMethodOn(new Object[0])).getFacetValues(facetData.getName(), null, query, dsoType, scope, configuration, null, null));
        this.addFilterParams(uriBuilder, searchData);
        if (CollectionUtils.isNotEmpty(facetData.getValues())) {
            PageImpl page = new PageImpl(facetData.getValues(), (Pageable)PageRequest.of((int)0, (int)facetData.getFacetLimit()), (long)(facetData.getValues().size() + (BooleanUtils.isTrue((Boolean)facetData.isHasMore()) ? 1 : 0)));
            halResource.setPageHeader(new EmbeddedPageHeader(uriBuilder, (Page)page, false));
        } else {
            list.add(this.buildLink(IanaLinkRelations.SELF.value(), uriBuilder.build().toUriString()));
        }
    }

    @Override
    protected Class<SearchFacetEntryResource> getResourceClass() {
        return SearchFacetEntryResource.class;
    }
}

