/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import org.dspace.app.rest.converter.ConverterService;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.RelationshipRest;
import org.dspace.app.rest.model.RelationshipTypeRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.content.Relationship;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class RelationshipConverter
implements DSpaceConverter<Relationship, RelationshipRest> {
    @Lazy
    @Autowired
    private ConverterService converter;

    @Override
    public RelationshipRest convert(Relationship obj, Projection projection) {
        RelationshipRest relationshipRest = new RelationshipRest();
        relationshipRest.setProjection(projection);
        relationshipRest.setId(obj.getID());
        relationshipRest.setLeftId(obj.getLeftItem().getID());
        relationshipRest.setRelationshipType((RelationshipTypeRest)this.converter.toRest(obj.getRelationshipType(), projection));
        relationshipRest.setRightId(obj.getRightItem().getID());
        relationshipRest.setLeftPlace(obj.getLeftPlace());
        relationshipRest.setRightPlace(obj.getRightPlace());
        relationshipRest.setLeftwardValue(obj.getLeftwardValue());
        relationshipRest.setRightwardValue(obj.getRightwardValue());
        return relationshipRest;
    }

    @Override
    public Class<Relationship> getModelClass() {
        return Relationship.class;
    }
}

