/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.step.validation;

import jakarta.inject.Inject;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.dspace.app.rest.model.ErrorRest;
import org.dspace.app.rest.submit.SubmissionService;
import org.dspace.app.rest.submit.step.validation.AbstractValidation;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.license.CreativeCommonsServiceImpl;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class CclicenseValidator
extends AbstractValidation {
    private final ConfigurationService configurationService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private CreativeCommonsServiceImpl creativeCommonsService;
    public static final String ERROR_VALIDATION_CCLICENSEREQUIRED = "error.validation.cclicense.required";
    private String name;

    @Inject
    public CclicenseValidator(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    private List<ErrorRest> validateLicense(Item item, SubmissionStepConfig config) {
        ArrayList<ErrorRest> errors = new ArrayList<ErrorRest>(1);
        String licenseURI = this.creativeCommonsService.getLicenseURI(item);
        if (licenseURI == null || licenseURI.isBlank()) {
            this.addError(errors, ERROR_VALIDATION_CCLICENSEREQUIRED, "/sections/" + config.getId());
        }
        return errors;
    }

    public ItemService getItemService() {
        return this.itemService;
    }

    public void setItemService(ItemService itemService) {
        this.itemService = itemService;
    }

    public Boolean isRequired() {
        return this.configurationService.getBooleanProperty("cc.license.required", false);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<? extends ErrorRest> validate(SubmissionService submissionService, InProgressSubmission obj, SubmissionStepConfig config) throws DCInputsReaderException, SQLException {
        if (this.isRequired().booleanValue() && obj != null && obj.getItem() != null) {
            return this.validateLicense(obj.getItem(), config);
        }
        return List.of();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

