/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.submit.factory.impl;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.dspace.app.ldn.NotifyPatternToTrigger;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.service.NotifyPatternToTriggerService;
import org.dspace.app.ldn.service.NotifyService;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.step.DataNotify;
import org.dspace.coarnotify.NotifyConfigurationService;
import org.dspace.coarnotify.NotifyPattern;
import org.dspace.content.InProgressSubmission;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotifySubmissionService {
    @Autowired
    private NotifyPatternToTriggerService notifyPatternToTriggerService;
    @Autowired
    private NotifyConfigurationService coarNotifyConfigurationService;
    @Autowired
    private NotifyService notifyService;

    private NotifySubmissionService() {
    }

    public DataNotify getDataCOARNotify(InProgressSubmission obj) throws SQLException {
        Context context = new Context();
        List patternsToTrigger = this.notifyPatternToTriggerService.findByItem(context, obj.getItem());
        Map<String, List<Integer>> data = patternsToTrigger.stream().collect(Collectors.groupingBy(NotifyPatternToTrigger::getPattern, Collectors.mapping(patternToTrigger -> patternToTrigger.getNotifyService().getID(), Collectors.toList())));
        return new DataNotify(data);
    }

    public int extractIndex(String path) {
        Pattern pattern = Pattern.compile("/(\\d+)$");
        Matcher matcher = pattern.matcher(path);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        throw new UnprocessableEntityException("Index not found in the path");
    }

    public String extractPattern(String path) {
        Pattern pattern = Pattern.compile("/([^/]+)/([^/]+)/([^/]+)");
        Matcher matcher = pattern.matcher(path);
        if (matcher.find()) {
            String patternValue = matcher.group(3);
            String config = matcher.group(2);
            if (!this.isContainPattern(config, patternValue)) {
                throw new UnprocessableEntityException("Invalid Pattern (" + patternValue + ") of " + config);
            }
            return patternValue;
        }
        throw new UnprocessableEntityException("Pattern not found in the path");
    }

    private boolean isContainPattern(String config, String pattern) {
        List patterns = (List)this.coarNotifyConfigurationService.getPatterns().get(config);
        if (CollectionUtils.isEmpty((Collection)patterns)) {
            return false;
        }
        return patterns.stream().map(NotifyPattern::getPattern).anyMatch(v -> v.equals(pattern));
    }

    public void checkCompatibilityWithPattern(Context context, String pattern, Set<Integer> servicesIds) throws SQLException {
        List manualServicesIds = this.notifyService.findManualServicesByInboundPattern(context, pattern).stream().map(NotifyServiceEntity::getID).collect(Collectors.toList());
        for (Integer servicesId : servicesIds) {
            if (manualServicesIds.contains(servicesId)) continue;
            throw new UnprocessableEntityException("notify service with id (" + servicesId + ") is not compatible with pattern " + pattern);
        }
    }
}

