/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.security.DSpaceRestPermission;
import org.dspace.app.rest.security.RestObjectPermissionEvaluatorPlugin;
import org.dspace.app.rest.utils.ContextUtil;
import org.dspace.core.Context;
import org.dspace.qaevent.service.QAEventSecurityService;
import org.dspace.services.RequestService;
import org.dspace.services.model.Request;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component
public class QASourceRestPermissionEvaluatorPlugin
extends RestObjectPermissionEvaluatorPlugin {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    private QAEventSecurityService qaEventSecurityService;
    @Autowired
    private RequestService requestService;

    @Override
    public boolean hasDSpacePermission(Authentication authentication, Serializable targetId, String targetType, DSpaceRestPermission restPermission) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"qualityassurancesource", (CharSequence)targetType) || StringUtils.equalsIgnoreCase((CharSequence)"qualityassurancetopic", (CharSequence)targetType)) {
            log.debug("Checking permission for targetId {}", (Object)targetId);
            Request request = this.requestService.getCurrentRequest();
            Context context = ContextUtil.obtainContext(request.getHttpServletRequest());
            if (Objects.isNull(targetId)) {
                return true;
            }
            String sourceName = targetId.toString().split(":")[0];
            return this.qaEventSecurityService.canSeeSource(context, context.getCurrentUser(), sourceName);
        }
        return false;
    }
}

