/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.model.SuggestionSourceRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.suggestion.SuggestionService;
import org.dspace.app.suggestion.SuggestionSource;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="integration.suggestionsources")
public class SuggestionSourceRestRepository
extends DSpaceRestRepository<SuggestionSourceRest, String> {
    private static final Logger log = LogManager.getLogger(SuggestionSourceRestRepository.class);
    @Autowired
    private SuggestionService suggestionService;

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    public SuggestionSourceRest findOne(Context context, String source) {
        SuggestionSource suggestionSource = this.suggestionService.findSource(context, source);
        if (suggestionSource == null) {
            return null;
        }
        return (SuggestionSourceRest)this.converter.toRest(suggestionSource, this.utils.obtainProjection());
    }

    @Override
    @PreAuthorize(value="hasAuthority('ADMIN')")
    public Page<SuggestionSourceRest> findAll(Context context, Pageable pageable) {
        List suggestionSources = this.suggestionService.findAllSources(context, pageable.getPageSize(), pageable.getOffset());
        long count = this.suggestionService.countSources(context);
        if (suggestionSources == null) {
            return null;
        }
        return this.converter.toRestPage(suggestionSources, pageable, count, this.utils.obtainProjection());
    }

    @Override
    public Class<SuggestionSourceRest> getDomainClass() {
        return SuggestionSourceRest.class;
    }
}

