/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.UUID;
import org.dspace.access.status.service.AccessStatusService;
import org.dspace.app.rest.model.AccessStatusRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.AccessStatus;
import org.dspace.content.Bitstream;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.bitstreams.accessStatus")
public class BitstreamAccessStatusLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    BitstreamService bitstreamService;
    @Autowired
    AccessStatusService accessStatusService;

    @PreAuthorize(value="hasPermission(#bitstreamId, 'BITSTREAM', 'METADATA_READ')")
    public AccessStatusRest getAccessStatus(@Nullable HttpServletRequest request, UUID bitstreamId, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            Bitstream bitstream = this.bitstreamService.find(context, bitstreamId);
            if (bitstream == null) {
                throw new ResourceNotFoundException("No such bitstream: " + bitstreamId);
            }
            AccessStatusRest accessStatusRest = new AccessStatusRest();
            AccessStatus accessStatus = this.accessStatusService.getAccessStatus(context, bitstream);
            String status = accessStatus.getStatus();
            if (status == "embargo") {
                LocalDate availabilityDate = accessStatus.getAvailabilityDate();
                String embargoDate = availabilityDate.toString();
                accessStatusRest.setEmbargoDate(embargoDate);
            }
            accessStatusRest.setStatus(status);
            return accessStatusRest;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

