/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter;

import java.util.List;
import java.util.stream.Collectors;
import org.dspace.app.rest.converter.DSpaceConverter;
import org.dspace.app.rest.model.ResearcherProfileRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.orcid.model.OrcidEntityType;
import org.dspace.orcid.service.OrcidSynchronizationService;
import org.dspace.profile.OrcidEntitySyncPreference;
import org.dspace.profile.OrcidSynchronizationMode;
import org.dspace.profile.ResearcherProfile;
import org.dspace.web.ContextUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ResearcherProfileConverter
implements DSpaceConverter<ResearcherProfile, ResearcherProfileRest> {
    @Autowired
    private OrcidSynchronizationService orcidSynchronizationService;

    @Override
    public ResearcherProfileRest convert(ResearcherProfile profile, Projection projection) {
        ResearcherProfileRest researcherProfileRest = new ResearcherProfileRest();
        researcherProfileRest.setVisible(profile.isVisible());
        researcherProfileRest.setId(profile.getId());
        researcherProfileRest.setProjection(projection);
        Item item = profile.getItem();
        Context context = ContextUtil.obtainCurrentRequestContext();
        if (this.orcidSynchronizationService.isLinkedToOrcid(context, item)) {
            profile.getOrcid().ifPresent(researcherProfileRest::setOrcid);
            ResearcherProfileRest.OrcidSynchronizationRest orcidSynchronization = new ResearcherProfileRest.OrcidSynchronizationRest();
            orcidSynchronization.setMode(this.getMode(item));
            orcidSynchronization.setProfilePreferences(this.getProfilePreferences(item));
            orcidSynchronization.setFundingsPreference(this.getFundingsPreference(item));
            orcidSynchronization.setPublicationsPreference(this.getPublicationsPreference(item));
            researcherProfileRest.setOrcidSynchronization(orcidSynchronization);
        }
        return researcherProfileRest;
    }

    private String getPublicationsPreference(Item item) {
        return this.orcidSynchronizationService.getEntityPreference(item, OrcidEntityType.PUBLICATION).map(Enum::name).orElse(OrcidEntitySyncPreference.DISABLED.name());
    }

    private String getFundingsPreference(Item item) {
        return this.orcidSynchronizationService.getEntityPreference(item, OrcidEntityType.FUNDING).map(Enum::name).orElse(OrcidEntitySyncPreference.DISABLED.name());
    }

    private List<String> getProfilePreferences(Item item) {
        return this.orcidSynchronizationService.getProfilePreferences(item).stream().map(Enum::name).collect(Collectors.toList());
    }

    private String getMode(Item item) {
        return this.orcidSynchronizationService.getSynchronizationMode(item).map(Enum::name).orElse(OrcidSynchronizationMode.MANUAL.name());
    }

    @Override
    public Class<ResearcherProfile> getModelClass() {
        return ResearcherProfile.class;
    }
}

