/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation;

import com.fasterxml.jackson.databind.JsonNode;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Optional;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.patch.JsonValueEvaluator;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.RegistrationData;
import org.dspace.eperson.RegistrationTypeEnum;
import org.dspace.eperson.dto.RegistrationDataChanges;
import org.dspace.eperson.dto.RegistrationDataPatch;
import org.dspace.eperson.service.AccountService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RegistrationEmailPatchOperation<R extends RegistrationData>
extends PatchOperation<R> {
    private static final String OPERATION_PATH_EMAIL = "/email";
    @Autowired
    private AccountService accountService;

    @Override
    public R perform(Context context, R object, Operation operation) {
        RegistrationDataPatch registrationDataPatch;
        this.checkOperationValue(operation.getValue());
        try {
            String email = RegistrationEmailPatchOperation.getTextValue(operation);
            registrationDataPatch = new RegistrationDataPatch(object, new RegistrationDataChanges(email, this.registrationTypeFor(context, object, email)));
        }
        catch (IllegalArgumentException e) {
            throw new UnprocessableEntityException("Cannot perform the patch operation", e);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        if (!this.supports(object, operation)) {
            throw new UnprocessableEntityException(MessageFormat.format("RegistrationEmailReplaceOperation does not support {0} operation", operation.getOp()));
        }
        if (!this.isOperationAllowed(operation, (RegistrationData)object)) {
            throw new UnprocessableEntityException(MessageFormat.format("Attempting to perform {0} operation over {1} value (e-mail).", operation.getOp(), object.getEmail() == null ? "null" : "not null"));
        }
        try {
            return (R)this.accountService.renewRegistrationForEmail(context, registrationDataPatch);
        }
        catch (AuthorizeException e) {
            throw new DSpaceBadRequestException(MessageFormat.format("Cannot perform {0} operation over {1} value (e-mail).", operation.getOp(), object.getEmail() == null ? "null" : "not null"), (Exception)((Object)e));
        }
    }

    private static String getTextValue(Operation operation) {
        Object value = operation.getValue();
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof JsonValueEvaluator) {
            return Optional.of((JsonValueEvaluator)value).map(JsonValueEvaluator::getValueNode).filter(nodes -> !nodes.isEmpty()).map(nodes -> nodes.get(0)).map(JsonNode::asText).orElseThrow(() -> new DSpaceBadRequestException("No value provided for operation"));
        }
        throw new DSpaceBadRequestException("Invalid patch value for operation!");
    }

    private RegistrationTypeEnum registrationTypeFor(Context context, R object, String email) throws SQLException {
        if (this.accountService.existsAccountWithEmail(context, email)) {
            return RegistrationTypeEnum.VALIDATION_ORCID;
        }
        return object.getRegistrationType();
    }

    private boolean isOperationAllowed(Operation operation, RegistrationData registrationData) {
        return RegistrationEmailPatchOperation.isReplaceOperationAllowed(operation, registrationData) || this.isAddOperationAllowed(operation, registrationData);
    }

    private boolean isAddOperationAllowed(Operation operation, RegistrationData registrationData) {
        return operation.getOp().trim().equalsIgnoreCase("add") && registrationData.getEmail() == null;
    }

    private static boolean isReplaceOperationAllowed(Operation operation, RegistrationData registrationData) {
        return operation.getOp().trim().equalsIgnoreCase("replace") && registrationData.getEmail() != null;
    }

    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch instanceof RegistrationData && (operation.getOp().trim().equalsIgnoreCase("replace") || operation.getOp().trim().equalsIgnoreCase("add")) && operation.getPath().trim().equalsIgnoreCase(OPERATION_PATH_EMAIL);
    }
}

