/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.mail.MessagingException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.BadRequestException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.RegistrationRest;
import org.dspace.app.rest.model.patch.Patch;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.app.rest.repository.patch.ResourcePatch;
import org.dspace.app.rest.utils.Utils;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.InvalidReCaptchaException;
import org.dspace.eperson.RegistrationData;
import org.dspace.eperson.RegistrationTypeEnum;
import org.dspace.eperson.factory.CaptchaServiceFactory;
import org.dspace.eperson.service.AccountService;
import org.dspace.eperson.service.CaptchaService;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.RegistrationDataService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.RequestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="eperson.registrations")
public class RegistrationRestRepository
extends DSpaceRestRepository<RegistrationRest, Integer> {
    private static Logger log = LogManager.getLogger(RegistrationRestRepository.class);
    public static final String TOKEN_QUERY_PARAM = "token";
    public static final String TYPE_QUERY_PARAM = "accountRequestType";
    public static final String TYPE_REGISTER = RegistrationTypeEnum.REGISTER.toString().toLowerCase();
    public static final String TYPE_FORGOT = RegistrationTypeEnum.FORGOT.toString().toLowerCase();
    @Autowired
    private EPersonService ePersonService;
    @Autowired
    private AccountService accountService;
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private RequestService requestService;
    private CaptchaService captchaService = CaptchaServiceFactory.getInstance().getCaptchaService();
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private RegistrationDataService registrationDataService;
    @Autowired
    private Utils utils;
    @Autowired
    private ResourcePatch<RegistrationData> resourcePatch;
    @Autowired
    private ObjectMapper mapper;

    @Override
    @PreAuthorize(value="permitAll()")
    public RegistrationRest findOne(Context context, Integer integer) {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed!", "");
    }

    @Override
    public Page<RegistrationRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("No implementation found; Method not allowed!", "");
    }

    @Override
    public RegistrationRest createAndReturn(Context context) {
        RegistrationRest registrationRest;
        HttpServletRequest request = this.requestService.getCurrentRequest().getHttpServletRequest();
        String accountType = request.getParameter(TYPE_QUERY_PARAM);
        if (StringUtils.isBlank((CharSequence)accountType) || !accountType.equalsIgnoreCase(TYPE_FORGOT) && !accountType.equalsIgnoreCase(TYPE_REGISTER)) {
            throw new IllegalArgumentException(String.format("Needs query param '%s' with value %s or %s indicating what kind of registration request it is", TYPE_QUERY_PARAM, TYPE_FORGOT, TYPE_REGISTER));
        }
        String captchaToken = request.getHeader("x-captcha-payload");
        boolean verificationEnabled = this.configurationService.getBooleanProperty("registration.verification.enabled");
        if (verificationEnabled && !accountType.equalsIgnoreCase(TYPE_FORGOT)) {
            try {
                this.captchaService.processResponse(captchaToken, "register_email");
            }
            catch (InvalidReCaptchaException e) {
                throw new InvalidReCaptchaException(e.getMessage(), (Exception)((Object)e));
            }
        }
        try {
            ServletInputStream input = request.getInputStream();
            registrationRest = (RegistrationRest)this.mapper.readValue((InputStream)input, RegistrationRest.class);
        }
        catch (IOException e1) {
            throw new UnprocessableEntityException("Error parsing request body.", e1);
        }
        if (StringUtils.isBlank((CharSequence)registrationRest.getEmail())) {
            throw new UnprocessableEntityException("The email cannot be omitted from the Registration endpoint");
        }
        EPerson eperson = null;
        try {
            eperson = this.ePersonService.findByEmail(context, registrationRest.getEmail());
        }
        catch (SQLException e) {
            log.error("Something went wrong retrieving EPerson for email: " + registrationRest.getEmail(), (Throwable)e);
        }
        if (eperson != null && accountType.equalsIgnoreCase(TYPE_FORGOT)) {
            try {
                if (!AuthorizeUtil.authorizeForgotPassword()) {
                    throw new AccessDeniedException("Password reset is not allowed!");
                }
                if (!AuthorizeUtil.authorizeUpdatePassword((Context)context, (String)eperson.getEmail())) {
                    throw new DSpaceBadRequestException("Password cannot be updated for the given EPerson with email: " + eperson.getEmail());
                }
                this.accountService.sendForgotPasswordInfo(context, registrationRest.getEmail());
            }
            catch (MessagingException | IOException | SQLException | AuthorizeException e) {
                log.error("Something went wrong with sending forgot password info email: " + registrationRest.getEmail(), e);
            }
        } else if (accountType.equalsIgnoreCase(TYPE_REGISTER)) {
            try {
                String email = registrationRest.getEmail();
                if (!AuthorizeUtil.authorizeNewAccountRegistration((Context)context, (HttpServletRequest)request)) {
                    throw new AccessDeniedException("Registration is disabled, you are not authorized to create a new Authorization");
                }
                if (!this.authenticationService.canSelfRegister(context, request, registrationRest.getEmail())) {
                    throw new UnprocessableEntityException(String.format("Registration is not allowed with email address %s", email));
                }
                this.accountService.sendRegistrationInfo(context, registrationRest.getEmail());
            }
            catch (MessagingException | IOException | SQLException | AuthorizeException e) {
                log.error("Something went wrong with sending registration info email: " + registrationRest.getEmail(), e);
            }
        } else {
            try {
                this.accountService.sendForgotPasswordInfo(context, registrationRest.getEmail());
            }
            catch (MessagingException | IOException | SQLException | AuthorizeException e) {
                log.error("Something went wrong with sending forgot password info email: " + registrationRest.getEmail(), e);
            }
        }
        return null;
    }

    @SearchRestMethod(name="findByToken")
    public RegistrationRest findByToken(@Parameter(value="token", required=true) String token) throws SQLException, AuthorizeException {
        Context context = this.obtainContext();
        RegistrationData registrationData = this.registrationDataService.findByToken(context, token);
        if (registrationData == null) {
            throw new ResourceNotFoundException("The token: " + token + " couldn't be found");
        }
        return (RegistrationRest)this.converter.toRest(registrationData, this.utils.obtainProjection());
    }

    private void validateToken(Context context, String token) {
        try {
            RegistrationData registrationData = this.registrationDataService.findByToken(context, token);
            if (registrationData == null || !this.registrationDataService.isValid(registrationData)) {
                throw new AccessDeniedException("The token is invalid");
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RegistrationRest patch(HttpServletRequest request, String apiCategory, String model, Integer id, Patch patch) throws UnprocessableEntityException, DSpaceBadRequestException {
        if (id == null || id <= 0) {
            throw new BadRequestException("The id of the registration cannot be null or negative");
        }
        if (patch == null || patch.getOperations() == null || patch.getOperations().isEmpty()) {
            throw new BadRequestException("Patch request is incomplete: cannot find operations");
        }
        String token = request.getParameter(TOKEN_QUERY_PARAM);
        if (token == null || token.trim().isBlank()) {
            throw new AccessDeniedException("The token is required");
        }
        Context context = this.obtainContext();
        this.validateToken(context, token);
        try {
            this.resourcePatch.patch(context, (RegistrationData)this.registrationDataService.find(context, id.intValue()), patch.getOperations());
            context.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return null;
    }

    public void setCaptchaService(CaptchaService captchaService) {
        this.captchaService = captchaService;
    }

    @Override
    public Class<RegistrationRest> getDomainClass() {
        return RegistrationRest.class;
    }
}

