/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.model.BitstreamRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.app.rest.repository.ProcessRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="system.processes.files")
public class ProcessFilesLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    private static final Logger log = LogManager.getLogger();
    @Autowired
    private ProcessRestRepository processRestRepository;

    @PreAuthorize(value="hasPermission(#processId, 'PROCESS', 'READ')")
    public Page<BitstreamRest> getFilesFromProcess(@Nullable HttpServletRequest request, Integer processId, @Nullable Pageable optionalPageable, Projection projection) throws SQLException, AuthorizeException {
        List<BitstreamRest> list = this.processRestRepository.getProcessBitstreams(processId);
        Pageable pageable = this.utils.getPageable(optionalPageable);
        return this.utils.getPage(list, pageable);
    }

    @PreAuthorize(value="hasPermission(#processId, 'PROCESS', 'READ')")
    public BitstreamRest getResource(HttpServletRequest request, String processId, String fileType, Pageable pageable, Projection projection) throws SQLException, AuthorizeException {
        if (log.isTraceEnabled()) {
            log.trace("Retrieving Files with type " + fileType + " from Process with ID: " + processId);
        }
        return this.processRestRepository.getProcessBitstreamByType(Integer.parseInt(processId), fileType);
    }
}

