/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import org.dspace.app.bulkaccesscontrol.model.BulkAccessConditionConfiguration;
import org.dspace.app.bulkaccesscontrol.service.BulkAccessConditionConfigurationService;
import org.dspace.app.rest.exception.RESTAuthorizationException;
import org.dspace.app.rest.model.BulkAccessConditionRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="config.bulkaccessconditionoptions")
public class BulkAccessConditionRestRepository
extends DSpaceRestRepository<BulkAccessConditionRest, String> {
    @Autowired
    private BulkAccessConditionConfigurationService bulkAccessConditionConfigurationService;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    @PreAuthorize(value="permitAll()")
    public BulkAccessConditionRest findOne(Context context, String id) {
        if (!this.isAuthorized(context)) {
            throw new RESTAuthorizationException("Only admin users of community or collection or item are allowed to bulk access condition");
        }
        BulkAccessConditionConfiguration bulkConfiguration = this.bulkAccessConditionConfigurationService.getBulkAccessConditionConfiguration(id);
        return Objects.nonNull(bulkConfiguration) ? (BulkAccessConditionRest)this.converter.toRest(bulkConfiguration, this.utils.obtainProjection()) : null;
    }

    @Override
    @PreAuthorize(value="permitAll()")
    public Page<BulkAccessConditionRest> findAll(Context context, Pageable pageable) {
        if (!this.isAuthorized(context)) {
            throw new RESTAuthorizationException("Only admin users of community or collection or item are allowed to bulk access condition");
        }
        List configurations = this.bulkAccessConditionConfigurationService.getBulkAccessConditionConfigurations();
        return this.converter.toRestPage(configurations, pageable, configurations.size(), this.utils.obtainProjection());
    }

    @Override
    public Class<BulkAccessConditionRest> getDomainClass() {
        return BulkAccessConditionRest.class;
    }

    private boolean isAuthorized(Context context) {
        try {
            return context.getCurrentUser() != null && (this.authorizeService.isAdmin(context) || this.authorizeService.isComColAdmin(context) || this.authorizeService.isItemAdmin(context));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

