/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.model.hateoas;

import org.dspace.app.rest.RestResourceController;
import org.dspace.app.rest.model.BrowseIndexRest;
import org.dspace.app.rest.model.hateoas.DSpaceResource;
import org.dspace.app.rest.model.hateoas.annotations.RelNameDSpaceResource;
import org.dspace.app.rest.utils.Utils;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.factory.ContentAuthorityServiceFactory;
import org.dspace.content.authority.service.ChoiceAuthorityService;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@RelNameDSpaceResource(value="browse")
public class BrowseIndexResource
extends DSpaceResource<BrowseIndexRest> {
    public BrowseIndexResource(BrowseIndexRest bix, Utils utils) {
        super(bix, utils);
        if (bix.getBrowseType().equals("valueList")) {
            this.add(utils.linkToSubResource(bix, "entries"));
            this.add(utils.linkToSubResource(bix, "items"));
        }
        if (bix.getBrowseType().equals("flatBrowse")) {
            this.add(utils.linkToSubResource(bix, "items"));
        }
        if (bix.getBrowseType().equals("hierarchicalBrowse")) {
            ChoiceAuthorityService choiceAuthorityService = ContentAuthorityServiceFactory.getInstance().getChoiceAuthorityService();
            ChoiceAuthority source = choiceAuthorityService.getChoiceAuthorityByAuthorityName(bix.getVocabulary());
            UriComponentsBuilder baseLink = WebMvcLinkBuilder.linkTo((Object)((RestResourceController)WebMvcLinkBuilder.methodOn(RestResourceController.class, (Object[])new Object[]{"authn"})).findRel(null, null, "submission", "vocabularies", source.getPluginInstanceName(), "", null, null)).toUriComponentsBuilder();
            this.add(Link.of((String)baseLink.build().encode().toUriString(), (String)"vocabulary"));
        }
    }
}

