/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.link.externalsources;

import java.util.LinkedList;
import org.dspace.app.rest.ExternalSourcesRestController;
import org.dspace.app.rest.link.HalLinkFactory;
import org.dspace.app.rest.model.ExternalSourceEntryRest;
import org.dspace.app.rest.model.hateoas.ExternalSourceEntryResource;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.stereotype.Component;

@Component
public class ExternalSourceEntryHalLinkFactory
extends HalLinkFactory<ExternalSourceEntryResource, ExternalSourcesRestController> {
    @Override
    protected void addLinks(ExternalSourceEntryResource halResource, Pageable pageable, LinkedList<Link> list) throws Exception {
        String externalSource = ((ExternalSourceEntryRest)halResource.getContent()).getExternalSource();
        String id = ((ExternalSourceEntryRest)halResource.getContent()).getId();
        list.add(this.buildLink(((ExternalSourcesRestController)this.getMethodOn(new Object[0])).getExternalSourceEntryValue(externalSource, id), IanaLinkRelations.SELF.value()));
    }

    private <T> Link buildLink(T data, String rel) {
        return WebMvcLinkBuilder.linkTo(data).withRel(rel);
    }

    @Override
    protected Class<ExternalSourcesRestController> getControllerClass() {
        return ExternalSourcesRestController.class;
    }

    @Override
    protected Class<ExternalSourceEntryResource> getResourceClass() {
        return ExternalSourceEntryResource.class;
    }
}

