/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.link;

import java.util.LinkedList;
import org.dspace.app.rest.RestResourceController;
import org.dspace.app.rest.link.HalLinkFactory;
import org.dspace.app.rest.model.OrcidQueueRest;
import org.dspace.app.rest.model.hateoas.OrcidQueueResource;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class OrcidQueueHalLinkFactory
extends HalLinkFactory<OrcidQueueResource, RestResourceController> {
    @Override
    protected void addLinks(OrcidQueueResource halResource, Pageable pageable, LinkedList<Link> list) throws Exception {
        String uribuilder;
        UriComponentsBuilder uriComponentsBuilder;
        OrcidQueueRest orcidQueueRest = (OrcidQueueRest)halResource.getContent();
        if (orcidQueueRest.getProfileItemId() != null) {
            uriComponentsBuilder = WebMvcLinkBuilder.linkTo((Object)((RestResourceController)this.getMethodOn("core", "item")).findRel(null, null, "core", "items", orcidQueueRest.getProfileItemId(), "", null, null)).toUriComponentsBuilder();
            uribuilder = uriComponentsBuilder.build().toString();
            list.add(this.buildLink("profileItem", uribuilder.substring(0, uribuilder.lastIndexOf("/"))));
        }
        if (orcidQueueRest.getEntityId() != null) {
            uriComponentsBuilder = WebMvcLinkBuilder.linkTo((Object)((RestResourceController)this.getMethodOn("core", "item")).findRel(null, null, "core", "items", orcidQueueRest.getEntityId(), "", null, null)).toUriComponentsBuilder();
            uribuilder = uriComponentsBuilder.build().toString();
            list.add(this.buildLink("entity", uribuilder.substring(0, uribuilder.lastIndexOf("/"))));
        }
    }

    @Override
    protected Class<RestResourceController> getControllerClass() {
        return RestResourceController.class;
    }

    @Override
    protected Class<OrcidQueueResource> getResourceClass() {
        return OrcidQueueResource.class;
    }
}

