/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.converter.query;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.rest.model.query.RestSearchOperator;
import org.dspace.app.rest.parameter.SearchFilter;

public class SearchQueryConverter {
    public List<SearchFilter> convert(List<SearchFilter> searchFilters) {
        LinkedList<SearchFilter> transformedSearchFilters = new LinkedList<SearchFilter>();
        for (SearchFilter searchFilter : CollectionUtils.emptyIfNull(searchFilters)) {
            if (StringUtils.equals((CharSequence)searchFilter.getOperator(), (CharSequence)"query")) {
                SearchFilter transformedSearchFilter = this.convertQuerySearchFilterIntoStandardSearchFilter(searchFilter);
                transformedSearchFilters.add(transformedSearchFilter);
                continue;
            }
            transformedSearchFilters.add(searchFilter);
        }
        return transformedSearchFilters;
    }

    private SearchFilter convertQuerySearchFilterIntoStandardSearchFilter(SearchFilter searchFilter) {
        RestSearchOperator restSearchOperator = RestSearchOperator.forQuery(searchFilter.getValue());
        SearchFilter transformedSearchFilter = new SearchFilter(searchFilter.getName(), restSearchOperator.getDspaceOperator(), restSearchOperator.extractValue(searchFilter.getValue()));
        return transformedSearchFilter;
    }
}

