/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.security;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.security.DSpaceAuthentication;
import org.dspace.app.rest.security.RestAuthenticationService;
import org.dspace.app.rest.security.StatelessLoginFilter;
import org.dspace.authenticate.ShibAuthentication;
import org.dspace.core.Utils;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.ProviderNotFoundException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class ShibbolethLoginFilter
extends StatelessLoginFilter {
    private static final Logger log = LogManager.getLogger(ShibbolethLoginFilter.class);
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    public ShibbolethLoginFilter(String url, String httpMethod, AuthenticationManager authenticationManager, RestAuthenticationService restAuthenticationService) {
        super(url, httpMethod, authenticationManager, restAuthenticationService);
    }

    @Override
    public Authentication attemptAuthentication(HttpServletRequest req, HttpServletResponse res) throws AuthenticationException {
        if (!ShibAuthentication.isEnabled()) {
            throw new ProviderNotFoundException("Shibboleth is disabled.");
        }
        return this.authenticationManager.authenticate((Authentication)new DSpaceAuthentication());
    }

    @Override
    protected void successfulAuthentication(HttpServletRequest req, HttpServletResponse res, FilterChain chain, Authentication auth) throws IOException, ServletException {
        DSpaceAuthentication dSpaceAuthentication = (DSpaceAuthentication)auth;
        log.debug("Shib authentication successful for EPerson {}. Sending back temporary auth cookie", (Object)dSpaceAuthentication.getName());
        this.restAuthenticationService.addAuthenticationDataForUser(req, res, dSpaceAuthentication, true);
        this.redirectAfterSuccess(req, res);
    }

    private void redirectAfterSuccess(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String[] allowedUrls;
        String redirectUrl = request.getParameter("redirectUrl");
        if (StringUtils.isEmpty((CharSequence)redirectUrl)) {
            redirectUrl = this.configurationService.getProperty("dspace.ui.url");
        }
        String redirectHostName = Utils.getHostName((String)redirectUrl);
        String serverHostName = Utils.getHostName((String)this.configurationService.getProperty("dspace.server.url"));
        ArrayList<String> allowedHostNames = new ArrayList<String>();
        allowedHostNames.add(serverHostName);
        for (String url : allowedUrls = this.configurationService.getArrayProperty("rest.cors.allowed-origins")) {
            allowedHostNames.add(Utils.getHostName((String)url));
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)redirectHostName, (CharSequence[])allowedHostNames.toArray(new String[0]))) {
            log.debug("Shibboleth redirecting to " + redirectUrl);
            response.sendRedirect(redirectUrl);
        } else {
            log.error("Invalid Shibboleth redirectURL=" + redirectUrl + ". URL doesn't match hostname of server or UI!");
            response.sendError(400, "Invalid redirectURL! Must match server or ui hostname.");
        }
    }
}

