/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository.patch.operation.ldn;

import java.sql.SQLException;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.service.NotifyService;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.patch.Operation;
import org.dspace.app.rest.repository.patch.operation.PatchOperation;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotifyServiceUrlReplaceOperation
extends PatchOperation<NotifyServiceEntity> {
    @Autowired
    private NotifyService notifyService;
    private static final String OPERATION_PATH = "/url";

    @Override
    public NotifyServiceEntity perform(Context context, NotifyServiceEntity notifyServiceEntity, Operation operation) throws SQLException {
        this.checkOperationValue(operation.getValue());
        Object url = operation.getValue();
        if (url == null | !(url instanceof String)) {
            throw new UnprocessableEntityException("The /url value must be a string");
        }
        this.checkModelForExistingValue(notifyServiceEntity);
        notifyServiceEntity.setUrl((String)url);
        this.notifyService.update(context, notifyServiceEntity);
        return notifyServiceEntity;
    }

    private void checkModelForExistingValue(NotifyServiceEntity notifyServiceEntity) {
        if (notifyServiceEntity.getUrl() == null) {
            throw new DSpaceBadRequestException("Attempting to replace a non-existent value (url).");
        }
    }

    @Override
    public boolean supports(Object objectToMatch, Operation operation) {
        return objectToMatch instanceof NotifyServiceEntity && operation.getOp().trim().equalsIgnoreCase("replace") && operation.getPath().trim().toLowerCase().equalsIgnoreCase(OPERATION_PATH);
    }
}

