/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.RelationshipRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.core.Context;
import org.dspace.core.ReloadableEntity;
import org.dspace.eperson.EPerson;
import org.dspace.services.RequestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.relationships")
public class RelationshipRestRepository
extends DSpaceRestRepository<RelationshipRest, Integer> {
    private static final Logger log = LogManager.getLogger();
    private static final String ALL = "all";
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    private static final String CONFIGURED = "configured";
    @Autowired
    private EntityTypeService entityTypeService;
    @Autowired
    private ItemService itemService;
    @Autowired
    private RelationshipService relationshipService;
    @Autowired
    private RelationshipTypeService relationshipTypeService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private RequestService requestService;

    @Override
    @PreAuthorize(value="permitAll()")
    public RelationshipRest findOne(Context context, Integer integer) {
        try {
            Relationship relationship = (Relationship)this.relationshipService.find(context, integer.intValue());
            if (relationship == null) {
                return null;
            }
            return (RelationshipRest)this.converter.toRest(relationship, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Page<RelationshipRest> findAll(Context context, Pageable pageable) {
        try {
            long total = this.relationshipService.countTotal(context);
            List relationships = this.relationshipService.findAll(context, Integer.valueOf(pageable.getPageSize()), Integer.valueOf(Math.toIntExact(pageable.getOffset())));
            return this.converter.toRestPage(relationships, pageable, total, this.utils.obtainProjection());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Class<RelationshipRest> getDomainClass() {
        return RelationshipRest.class;
    }

    @Override
    protected RelationshipRest createAndReturn(Context context, List<String> stringList) throws AuthorizeException, SQLException, RepositoryMethodNotImplementedException {
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        List<DSpaceObject> list = this.utils.constructDSpaceObjectList(context, stringList);
        if (list.size() == 2 && list.get(0).getType() == 2 && list.get(1).getType() == 2) {
            Item leftItem = (Item)list.get(0);
            Item rightItem = (Item)list.get(1);
            RelationshipType relationshipType = (RelationshipType)this.relationshipTypeService.find(context, Integer.parseInt(req.getParameter("relationshipType")));
            String leftwardValue = req.getParameter("leftwardValue");
            String rightwardValue = req.getParameter("rightwardValue");
            EPerson ePerson = context.getCurrentUser();
            if (this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)leftItem, 1) || this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)rightItem, 1)) {
                Relationship relationship = this.relationshipService.create(context, leftItem, rightItem, relationshipType, -1, -1, leftwardValue, rightwardValue);
                return (RelationshipRest)this.converter.toRest(relationship, this.utils.obtainProjection());
            }
            throw new AccessDeniedException("You do not have write rights on this relationship's items");
        }
        throw new UnprocessableEntityException("The given items in the request were not valid items");
    }

    public RelationshipRest put(Context context, String contextPath, Integer id, List<String> stringList, Boolean itemToReplaceIsRight) throws SQLException {
        Relationship relationship;
        try {
            relationship = (Relationship)this.relationshipService.find(context, id.intValue());
        }
        catch (SQLException e) {
            throw new ResourceNotFoundException(contextPath + " with id: " + id + " not found");
        }
        if (relationship == null) {
            throw new ResourceNotFoundException(contextPath + " with id: " + id + " not found");
        }
        List<DSpaceObject> dSpaceObjects = this.utils.constructDSpaceObjectList(context, stringList);
        if (dSpaceObjects.size() == 1 && dSpaceObjects.get(0).getType() == 2) {
            Item newRightItem;
            Item newLeftItem;
            Item replacementItemInRelationship = (Item)dSpaceObjects.get(0);
            if (itemToReplaceIsRight.booleanValue()) {
                newLeftItem = null;
                newRightItem = replacementItemInRelationship;
            } else {
                newLeftItem = replacementItemInRelationship;
                newRightItem = null;
            }
            if (this.isAllowedToModifyRelationship(context, relationship, newLeftItem, newRightItem)) {
                try {
                    this.relationshipService.move(context, relationship, newLeftItem, newRightItem);
                    context.commit();
                    context.reloadEntity((ReloadableEntity)relationship);
                }
                catch (AuthorizeException e) {
                    throw new AccessDeniedException("You do not have write rights on this relationship's items");
                }
                return (RelationshipRest)this.converter.toRest(relationship, this.utils.obtainProjection());
            }
            throw new AccessDeniedException("You do not have write rights on this relationship's items");
        }
        throw new UnprocessableEntityException("The given items in the request were not valid");
    }

    @Override
    protected RelationshipRest put(Context context, HttpServletRequest request, String apiCategory, String model, Integer id, JsonNode jsonNode) throws RepositoryMethodNotImplementedException, SQLException, AuthorizeException {
        Relationship relationship;
        try {
            relationship = (Relationship)this.relationshipService.find(context, id.intValue());
        }
        catch (SQLException e) {
            throw new ResourceNotFoundException("Relationship with id: " + id + " not found");
        }
        if (relationship == null) {
            throw new ResourceNotFoundException("Relationship with id: " + id + " not found");
        }
        try {
            RelationshipRest relationshipRest;
            try {
                relationshipRest = (RelationshipRest)new ObjectMapper().readValue(jsonNode.toString(), RelationshipRest.class);
            }
            catch (IOException e) {
                throw new UnprocessableEntityException("Error parsing request body: " + e.toString());
            }
            relationship.setLeftwardValue(relationshipRest.getLeftwardValue());
            relationship.setRightwardValue(relationshipRest.getRightwardValue());
            Integer newRightPlace = null;
            Integer newLeftPlace = null;
            if (jsonNode.hasNonNull("rightPlace")) {
                newRightPlace = relationshipRest.getRightPlace();
            }
            if (jsonNode.hasNonNull("leftPlace")) {
                newLeftPlace = relationshipRest.getLeftPlace();
            }
            this.relationshipService.move(context, relationship, newLeftPlace, newRightPlace);
            context.commit();
            context.reloadEntity((ReloadableEntity)relationship);
            return (RelationshipRest)this.converter.toRest(relationship, this.utils.obtainProjection());
        }
        catch (AuthorizeException e) {
            throw new AccessDeniedException("You do not have write rights on this relationship's metadata");
        }
    }

    private boolean isAllowedToModifyRelationship(Context context, Relationship relationship, Item leftItem, Item rightItem) throws SQLException {
        return leftItem == null || this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)leftItem, 1) || (rightItem == null || this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)rightItem, 1)) && (this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)relationship.getLeftItem(), 1) || this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)relationship.getRightItem(), 1));
    }

    @Override
    protected void delete(Context context, Integer id) throws AuthorizeException {
        block17: {
            String copyVirtual = this.requestService.getCurrentRequest().getServletRequest().getParameter("copyVirtualMetadata");
            if (copyVirtual == null) {
                copyVirtual = "none";
            }
            Relationship relationship = null;
            try {
                relationship = (Relationship)this.relationshipService.find(context, id.intValue());
                if (relationship == null) break block17;
                try {
                    switch (copyVirtual) {
                        case "all": {
                            this.relationshipService.delete(context, relationship, true, true);
                            break;
                        }
                        case "left": {
                            this.relationshipService.delete(context, relationship, true, false);
                            break;
                        }
                        case "right": {
                            this.relationshipService.delete(context, relationship, false, true);
                            break;
                        }
                        case "configured": {
                            this.relationshipService.delete(context, (Object)relationship);
                            break;
                        }
                        default: {
                            this.relationshipService.delete(context, relationship, false, false);
                            break;
                        }
                    }
                }
                catch (AuthorizeException e) {
                    throw new AccessDeniedException("You do not have write rights on this relationship's items");
                }
            }
            catch (SQLException e) {
                log.error("Error deleting Relationship specified by ID:" + id, (Throwable)e);
            }
        }
    }

    @SearchRestMethod(name="byLabel")
    public Page<RelationshipRest> findByLabel(@Parameter(value="label", required=true) String label, @Parameter(value="dso", required=false) UUID dsoId, @Parameter(value="relatedEntityType") String relatedEntityType, Pageable pageable) throws SQLException {
        Context context = this.obtainContext();
        List relationshipTypeList = this.relationshipTypeService.findByLeftwardOrRightwardTypeName(context, label);
        LinkedList relationships = new LinkedList();
        int total = 0;
        if (dsoId != null) {
            Item item = (Item)this.itemService.find(context, dsoId);
            if (item == null) {
                throw new ResourceNotFoundException("The request DSO with id: " + dsoId + " was not found");
            }
            EntityType dsoEntityType = this.itemService.getEntityType(context, item);
            if (dsoEntityType == null) {
                throw new UnprocessableEntityException(String.format("The request DSO with id: %s doesn't have an entity type", dsoId));
            }
            for (RelationshipType relationshipType : relationshipTypeList) {
                if (relatedEntityType != null && (!relationshipType.getRightType().getLabel().equals(dsoEntityType.getLabel()) || !relationshipType.getLeftType().getLabel().equals(relatedEntityType)) && (!relationshipType.getRightType().getLabel().equals(relatedEntityType) || !relationshipType.getLeftType().getLabel().equals(dsoEntityType.getLabel()))) continue;
                boolean isLeft = relationshipType.getLeftwardType().equalsIgnoreCase(label);
                total += this.relationshipService.countByItemAndRelationshipType(context, item, relationshipType, isLeft);
                relationships.addAll(this.relationshipService.findByItemAndRelationshipType(context, item, relationshipType, isLeft, pageable.getPageSize(), Math.toIntExact(pageable.getOffset())));
            }
        } else {
            for (RelationshipType relationshipType : relationshipTypeList) {
                total += this.relationshipService.countByRelationshipType(context, relationshipType);
                relationships.addAll(this.relationshipService.findByRelationshipType(context, relationshipType, Integer.valueOf(pageable.getPageSize()), Integer.valueOf(Math.toIntExact(pageable.getOffset()))));
            }
        }
        return this.converter.toRestPage(relationships, pageable, total, this.utils.obtainProjection());
    }

    @SearchRestMethod(name="byItemsAndType")
    public Page<RelationshipRest> findByItemsAndType(@Parameter(value="typeId", required=true) Integer typeId, @Parameter(value="relationshipLabel", required=true) String label, @Parameter(value="focusItem", required=true) UUID focusUUID, @Parameter(value="relatedItem", required=true) Set<UUID> items, Pageable pageable) throws SQLException {
        Context context = this.obtainContext();
        int total = 0;
        List relationships = new LinkedList();
        RelationshipType relationshipType = (RelationshipType)this.relationshipTypeService.find(context, typeId.intValue());
        if (Objects.nonNull(relationshipType)) {
            if (!relationshipType.getLeftwardType().equals(label) && !relationshipType.getRightwardType().equals(label)) {
                throw new UnprocessableEntityException("The provided label: " + label + " , does not match any relation!");
            }
            relationships = this.relationshipService.findByItemRelationshipTypeAndRelatedList(context, focusUUID, relationshipType, new ArrayList<UUID>(items), relationshipType.getLeftwardType().equals(label), Math.toIntExact(pageable.getOffset()), Math.toIntExact(pageable.getPageSize()));
            total = this.relationshipService.countByItemRelationshipTypeAndRelatedList(context, focusUUID, relationshipType, new ArrayList<UUID>(items), relationshipType.getLeftwardType().equals(label));
        }
        return this.converter.toRestPage(relationships, pageable, total, this.utils.obtainProjection());
    }
}

