/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.rest.Parameter;
import org.dspace.app.rest.SearchRestMethod;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.model.QATopicRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.core.Context;
import org.dspace.qaevent.QATopic;
import org.dspace.qaevent.service.QAEventService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="integration.qualityassurancetopics")
public class QATopicRestRepository
extends DSpaceRestRepository<QATopicRest, String> {
    static final String ORDER_FIELD = "topic";
    @Autowired
    private QAEventService qaEventService;
    private static final Logger log = LogManager.getLogger();

    @Override
    public Page<QATopicRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("Method not allowed!", "");
    }

    @Override
    @PreAuthorize(value="hasPermission(#id, 'QUALITYASSURANCETOPIC', 'READ')")
    public QATopicRest findOne(Context context, String id) {
        String[] topicIdSplitted = id.split(":", 3);
        if (topicIdSplitted.length < 2) {
            return null;
        }
        String sourceName = topicIdSplitted[0];
        String topicName = topicIdSplitted[1].replaceAll("!", "/");
        UUID target = topicIdSplitted.length == 3 ? UUID.fromString(topicIdSplitted[2]) : null;
        QATopic topic = this.qaEventService.findTopicBySourceAndNameAndTarget(context, sourceName, topicName, target);
        return topic != null ? (QATopicRest)this.converter.toRest(topic, this.utils.obtainProjection()) : null;
    }

    @SearchRestMethod(name="bySource")
    @PreAuthorize(value="hasPermission(#source, 'QUALITYASSURANCETOPIC', 'READ')")
    public Page<QATopicRest> findBySource(@Parameter(value="source", required=true) String source, Pageable pageable) {
        Context context = this.obtainContext();
        boolean ascending = false;
        if (pageable.getSort() != null && pageable.getSort().getOrderFor(ORDER_FIELD) != null) {
            ascending = pageable.getSort().getOrderFor(ORDER_FIELD).getDirection() == Sort.Direction.ASC;
        }
        List topics = this.qaEventService.findAllTopicsBySource(context, source, pageable.getOffset(), (long)pageable.getPageSize(), ORDER_FIELD, ascending);
        long count = this.qaEventService.countTopicsBySource(context, source);
        if (topics == null) {
            return null;
        }
        return this.converter.toRestPage(topics, pageable, count, this.utils.obtainProjection());
    }

    @SearchRestMethod(name="byTarget")
    @PreAuthorize(value="hasPermission(#target, 'ITEM', 'READ')")
    public Page<QATopicRest> findByTarget(@Parameter(value="target", required=true) UUID target, @Parameter(value="source", required=true) String source, Pageable pageable) {
        Context context = this.obtainContext();
        boolean ascending = false;
        if (pageable.getSort() != null && pageable.getSort().getOrderFor(ORDER_FIELD) != null) {
            ascending = pageable.getSort().getOrderFor(ORDER_FIELD).getDirection() == Sort.Direction.ASC;
        }
        List topics = this.qaEventService.findAllTopicsBySourceAndTarget(context, source, target, pageable.getOffset(), (long)pageable.getPageSize(), ORDER_FIELD, ascending);
        long count = this.qaEventService.countTopicsBySourceAndTarget(context, source, target);
        if (topics == null) {
            return null;
        }
        return this.converter.toRestPage(topics, pageable, count, this.utils.obtainProjection());
    }

    @Override
    public Class<QATopicRest> getDomainClass() {
        return QATopicRest.class;
    }
}

