/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import org.dspace.app.rest.model.WorkflowStepRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.core.Context;
import org.dspace.xmlworkflow.factory.XmlWorkflowFactory;
import org.dspace.xmlworkflow.storedcomponents.PoolTask;
import org.dspace.xmlworkflow.storedcomponents.service.PoolTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.stereotype.Component;

@Component(value="workflow.pooltasks.step")
public class PoolTaskStepLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    private PoolTaskService poolTaskService;
    @Autowired
    private XmlWorkflowFactory xmlWorkflowFactory;

    public WorkflowStepRest getStep(@Nullable HttpServletRequest request, Integer poolTaskId, @Nullable Pageable optionalPageable, Projection projection) {
        Context context = this.obtainContext();
        try {
            PoolTask poolTask = (PoolTask)this.poolTaskService.find(context, poolTaskId.intValue());
            if (poolTask == null) {
                throw new ResourceNotFoundException("ClaimedTask with id: " + poolTaskId + " wasn't found");
            }
            return (WorkflowStepRest)this.converter.toRest(this.xmlWorkflowFactory.getStepByName(poolTask.getStepID()), projection);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

