/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.UUID;
import org.dspace.access.status.service.AccessStatusService;
import org.dspace.app.rest.model.AccessStatusRest;
import org.dspace.app.rest.projection.Projection;
import org.dspace.app.rest.repository.AbstractDSpaceRestRepository;
import org.dspace.app.rest.repository.LinkRestRepository;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="core.items.accessStatus")
public class ItemAccessStatusLinkRepository
extends AbstractDSpaceRestRepository
implements LinkRestRepository {
    @Autowired
    ItemService itemService;
    @Autowired
    AccessStatusService accessStatusService;

    @PreAuthorize(value="hasPermission(#itemId, 'ITEM', 'READ')")
    public AccessStatusRest getAccessStatus(@Nullable HttpServletRequest request, UUID itemId, @Nullable Pageable optionalPageable, Projection projection) {
        try {
            Context context = this.obtainContext();
            Item item = (Item)this.itemService.find(context, itemId);
            if (item == null) {
                throw new ResourceNotFoundException("No such item: " + itemId);
            }
            AccessStatusRest accessStatusRest = new AccessStatusRest();
            String accessStatus = this.accessStatusService.getAccessStatus(context, item);
            accessStatusRest.setStatus(accessStatus);
            return accessStatusRest;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

