/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.mail.MessagingException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.dspace.app.rest.exception.DSpaceBadRequestException;
import org.dspace.app.rest.exception.DSpaceFeedbackNotFoundException;
import org.dspace.app.rest.exception.RepositoryMethodNotImplementedException;
import org.dspace.app.rest.exception.UnprocessableEntityException;
import org.dspace.app.rest.model.FeedbackRest;
import org.dspace.app.rest.repository.DSpaceRestRepository;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.service.FeedbackService;
import org.dspace.core.Context;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component(value="tools.feedbacks")
public class FeedbackRestRepository
extends DSpaceRestRepository<FeedbackRest, Integer> {
    @Autowired
    private FeedbackService feedbackService;
    @Autowired
    private ConfigurationService configurationService;

    @Override
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public Page<FeedbackRest> findAll(Context context, Pageable pageable) {
        throw new RepositoryMethodNotImplementedException("feedback", "findAll");
    }

    @Override
    @PreAuthorize(value="hasAuthority('AUTHENTICATED')")
    public FeedbackRest findOne(Context context, Integer id) {
        throw new RepositoryMethodNotImplementedException("feedback", "findOne");
    }

    @Override
    @PreAuthorize(value="permitAll()")
    protected FeedbackRest createAndReturn(Context context) throws AuthorizeException, SQLException {
        HttpServletRequest req = this.getRequestService().getCurrentRequest().getHttpServletRequest();
        ObjectMapper mapper = new ObjectMapper();
        FeedbackRest feedbackRest = null;
        String recipientEmail = this.configurationService.getProperty("feedback.recipient");
        if (StringUtils.isBlank((String)recipientEmail)) {
            throw new DSpaceFeedbackNotFoundException("Feedback cannot be sent at this time, Feedback recipient is disabled");
        }
        try {
            feedbackRest = (FeedbackRest)mapper.readValue((InputStream)req.getInputStream(), FeedbackRest.class);
        }
        catch (IOException exIO) {
            throw new UnprocessableEntityException("error parsing the body " + exIO.getMessage(), exIO);
        }
        String senderEmail = feedbackRest.getEmail();
        String message = feedbackRest.getMessage();
        if (StringUtils.isBlank((String)senderEmail) || StringUtils.isBlank((String)message)) {
            throw new DSpaceBadRequestException("e-mail and message fields are mandatory!");
        }
        String pageUrl = feedbackRest.getPage();
        String urlPrefix = this.configurationService.getProperty("dspace.ui.url");
        if (StringUtils.isNotBlank((String)pageUrl) && !StringUtils.startsWith((String)pageUrl, (String)urlPrefix)) {
            throw new DSpaceBadRequestException("unexpected page url was submitted");
        }
        try {
            this.feedbackService.sendEmail(context, req, recipientEmail, senderEmail, message, pageUrl);
        }
        catch (MessagingException | IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public Class<FeedbackRest> getDomainClass() {
        return FeedbackRest.class;
    }

    public FeedbackService getFeedbackService() {
        return this.feedbackService;
    }

    public void setFeedbackService(FeedbackService feedbackService) {
        this.feedbackService = feedbackService;
    }
}

