/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.rest.authorization.impl;

import java.sql.SQLException;
import org.dspace.app.rest.authorization.AuthorizationFeature;
import org.dspace.app.rest.authorization.AuthorizationFeatureDocumentation;
import org.dspace.app.rest.model.BaseObjectRest;
import org.dspace.app.rest.model.ItemRest;
import org.dspace.app.rest.model.SiteRest;
import org.dspace.app.rest.utils.Utils;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.discovery.SearchServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AuthorizationFeatureDocumentation(name="canEditItem", description="It can be used to verify if a user has rights to edit any item.")
public class EditItemFeature
implements AuthorizationFeature {
    public static final String NAME = "canEditItem";
    @Autowired
    AuthorizeService authService;
    @Autowired
    ItemService itemService;
    @Autowired
    Utils utils;

    @Override
    public boolean isAuthorized(Context context, BaseObjectRest object) throws SQLException, SearchServiceException {
        if (object instanceof SiteRest) {
            return this.itemService.countItemsWithEdit(context) > 0;
        }
        if (object instanceof ItemRest) {
            Item item = (Item)this.utils.getDSpaceAPIObjectFromRest(context, object);
            return this.authService.authorizeActionBoolean(context, (DSpaceObject)item, 1);
        }
        return false;
    }

    @Override
    public String[] getSupportedTypes() {
        return new String[]{"core.item", "core.site"};
    }
}

