/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.saml2;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;

public class DSpaceSamlAuthenticationFailureHandler
implements AuthenticationFailureHandler {
    private static final Logger logger = LoggerFactory.getLogger(DSpaceSamlAuthenticationFailureHandler.class);

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        logger.error("SAML authentication failed: {}", (Object)exception.getMessage());
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        response.sendRedirect(configurationService.getProperty("dspace.ui.url") + "/login");
    }
}

