/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.saml2;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.dspace.saml2.DSpaceSamlAuthRequest;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticatedPrincipal;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

public class DSpaceSamlAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private static final Logger logger = LoggerFactory.getLogger(DSpaceSamlAuthenticationSuccessHandler.class);
    protected ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        Saml2AuthenticatedPrincipal principal = (Saml2AuthenticatedPrincipal)authentication.getPrincipal();
        String relyingPartyId = principal.getRelyingPartyRegistrationId();
        Map samlAttributes = principal.getAttributes();
        samlAttributes.forEach((attributeName, values) -> values.forEach(value -> logger.info("Incoming SAML attribute: {} = {}", attributeName, value)));
        this.setRequestAttributesFromSamlAttributes(request, relyingPartyId, samlAttributes);
        request.setAttribute(this.getRelyingPartyIdAttributeName(), (Object)relyingPartyId);
        request.setAttribute(this.getNameIdAttributeName(), (Object)principal.getName());
        request.setAttribute("org.dspace.saml.ATTRIBUTES", (Object)samlAttributes);
        request.getRequestDispatcher("/api/authn/saml").forward((ServletRequest)new DSpaceSamlAuthRequest(request), (ServletResponse)response);
    }

    private void setRequestAttributesFromSamlAttributes(HttpServletRequest request, String relyingPartyId, Map<String, List<Object>> samlAttributes) {
        String[] attributeMappings = this.configurationService.getArrayProperty("saml-relying-party." + relyingPartyId + ".attributes");
        if (attributeMappings == null || attributeMappings.length == 0) {
            logger.warn("No SAML attribute mappings found for relying party {}", (Object)relyingPartyId);
            return;
        }
        Arrays.stream(attributeMappings).forEach(attributeMapping -> {
            String[] parts = attributeMapping.split("=>");
            if (parts.length != 2) {
                logger.error("Unable to parse SAML attribute mapping for relying party {}: {}", (Object)relyingPartyId, attributeMapping);
                return;
            }
            String samlAttributeName = parts[0].trim();
            String requestAttributeName = parts[1].trim();
            List values = (List)samlAttributes.get(samlAttributeName);
            if (values != null) {
                request.setAttribute(requestAttributeName, (Object)values);
            } else {
                logger.warn("No value found for SAML attribute {} in assertion", (Object)samlAttributeName);
            }
        });
    }

    private String getRelyingPartyIdAttributeName() {
        return this.configurationService.getProperty("authentication-saml.attribute.relying-party-id", "org.dspace.saml.RELYING_PARTY_ID");
    }

    private String getNameIdAttributeName() {
        return this.configurationService.getProperty("authentication-saml.attribute.name-id", "org.dspace.saml.NAME_ID");
    }
}

